/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetManager;
import com.jme3.material.ShaderGenerationInfo;
import com.jme3.material.Technique;
import com.jme3.material.TechniqueDef;
import com.jme3.shader.DefineList;
import com.jme3.shader.Shader;
import com.jme3.shader.ShaderNode;
import java.util.List;

public abstract class ShaderGenerator {
    protected AssetManager assetManager;
    protected int indent;
    protected Technique technique = null;

    protected ShaderGenerator(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    public void initialize(Technique technique) {
        this.technique = technique;
    }

    public Shader generateShader() {
        if (this.technique == null) {
            throw new UnsupportedOperationException("The shaderGenerator was not properly initialized, call initialize(Technique) before any generation");
        }
        DefineList defines = this.technique.getAllDefines();
        TechniqueDef def = this.technique.getDef();
        ShaderGenerationInfo info = def.getShaderGenerationInfo();
        String vertexSource = this.buildShader(def.getShaderNodes(), info, Shader.ShaderType.Vertex);
        String fragmentSource = this.buildShader(def.getShaderNodes(), info, Shader.ShaderType.Fragment);
        Shader shader = new Shader();
        shader.initialize();
        shader.addSource(Shader.ShaderType.Vertex, this.technique.getDef().getName() + ".vert", vertexSource, defines.getCompiled(), this.getLanguageAndVersion(Shader.ShaderType.Vertex));
        shader.addSource(Shader.ShaderType.Fragment, this.technique.getDef().getName() + ".frag", fragmentSource, defines.getCompiled(), this.getLanguageAndVersion(Shader.ShaderType.Fragment));
        this.technique = null;
        return shader;
    }

    protected String buildShader(List<ShaderNode> shaderNodes, ShaderGenerationInfo info, Shader.ShaderType type) {
        this.indent = 0;
        StringBuilder sourceDeclaration = new StringBuilder();
        StringBuilder source = new StringBuilder();
        this.generateUniforms(sourceDeclaration, info, type);
        if (type == Shader.ShaderType.Vertex) {
            this.generateAttributes(sourceDeclaration, info);
        }
        this.generateVaryings(sourceDeclaration, info, type);
        this.generateStartOfMainSection(source, info, type);
        this.generateDeclarationAndMainBody(shaderNodes, sourceDeclaration, source, info, type);
        this.generateEndOfMainSection(source, info, type);
        sourceDeclaration.append((CharSequence)source);
        return sourceDeclaration.toString();
    }

    protected void generateDeclarationAndMainBody(List<ShaderNode> shaderNodes, StringBuilder sourceDeclaration, StringBuilder source, ShaderGenerationInfo info, Shader.ShaderType type) {
        for (ShaderNode shaderNode : shaderNodes) {
            if (info.getUnusedNodes().contains(shaderNode.getName()) || shaderNode.getDefinition().getType() != type) continue;
            int index = this.findShaderIndexFromVersion(shaderNode, type);
            String shaderPath = shaderNode.getDefinition().getShadersPath().get(index);
            String loadedSource = (String)this.assetManager.loadAsset(new AssetKey(shaderPath));
            this.appendNodeDeclarationAndMain(loadedSource, sourceDeclaration, source, shaderNode, info, shaderPath);
        }
    }

    protected void appendNodeDeclarationAndMain(String loadedSource, StringBuilder sourceDeclaration, StringBuilder source, ShaderNode shaderNode, ShaderGenerationInfo info, String shaderPath) {
        if (loadedSource.length() > 1) {
            String[] sourceParts = (loadedSource = loadedSource.substring(0, loadedSource.lastIndexOf("}"))).split("\\s*void\\s*main\\s*\\(\\s*\\)\\s*\\{");
            if (sourceParts.length < 2) {
                throw new IllegalArgumentException("Syntax error in " + shaderPath + ". Cannot find 'void main(){' in \n" + loadedSource);
            }
            this.generateDeclarativeSection(sourceDeclaration, shaderNode, sourceParts[0], info);
            this.generateNodeMainSection(source, shaderNode, sourceParts[1], info);
        } else {
            this.generateNodeMainSection(source, shaderNode, loadedSource, info);
        }
    }

    protected abstract String getLanguageAndVersion(Shader.ShaderType var1);

    protected abstract void generateUniforms(StringBuilder var1, ShaderGenerationInfo var2, Shader.ShaderType var3);

    protected abstract void generateAttributes(StringBuilder var1, ShaderGenerationInfo var2);

    protected abstract void generateVaryings(StringBuilder var1, ShaderGenerationInfo var2, Shader.ShaderType var3);

    protected abstract void generateDeclarativeSection(StringBuilder var1, ShaderNode var2, String var3, ShaderGenerationInfo var4);

    protected abstract void generateStartOfMainSection(StringBuilder var1, ShaderGenerationInfo var2, Shader.ShaderType var3);

    protected abstract void generateEndOfMainSection(StringBuilder var1, ShaderGenerationInfo var2, Shader.ShaderType var3);

    protected abstract void generateNodeMainSection(StringBuilder var1, ShaderNode var2, String var3, ShaderGenerationInfo var4);

    protected int findShaderIndexFromVersion(ShaderNode shaderNode, Shader.ShaderType type) throws NumberFormatException {
        int index = 0;
        List<String> lang = shaderNode.getDefinition().getShadersLanguage();
        int genVersion = Integer.parseInt(this.getLanguageAndVersion(type).substring(4));
        int curVersion = 0;
        for (int i = 0; i < lang.size(); ++i) {
            int version = Integer.parseInt(lang.get(i).substring(4));
            if (version <= curVersion || version > genVersion) continue;
            curVersion = version;
            index = i;
        }
        return index;
    }
}

