/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.asset.AssetKey;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.shader.DefineList;
import com.jme3.shader.Shader;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Set;

public class ShaderKey
extends AssetKey<Shader> {
    protected EnumMap<Shader.ShaderType, String> shaderLanguage;
    protected EnumMap<Shader.ShaderType, String> shaderName;
    protected DefineList defines;
    protected int cachedHashedCode = 0;
    protected boolean usesShaderNodes = false;

    public ShaderKey() {
        this.shaderLanguage = new EnumMap(Shader.ShaderType.class);
        this.shaderName = new EnumMap(Shader.ShaderType.class);
    }

    public ShaderKey(DefineList defines, EnumMap<Shader.ShaderType, String> shaderLanguage, EnumMap<Shader.ShaderType, String> shaderName) {
        super("");
        this.name = ShaderKey.reducePath(this.getShaderName(Shader.ShaderType.Vertex));
        this.shaderLanguage = new EnumMap(Shader.ShaderType.class);
        this.shaderName = new EnumMap(Shader.ShaderType.class);
        this.defines = defines;
        for (Shader.ShaderType shaderType : shaderName.keySet()) {
            this.shaderName.put(shaderType, shaderName.get((Object)shaderType));
            this.shaderLanguage.put(shaderType, shaderLanguage.get((Object)shaderType));
        }
    }

    @Override
    public ShaderKey clone() {
        ShaderKey clone = (ShaderKey)super.clone();
        clone.cachedHashedCode = 0;
        clone.defines = this.defines.clone();
        return clone;
    }

    @Override
    public String toString() {
        return "V=" + this.name + ";";
    }

    private final String getShaderName(Shader.ShaderType type) {
        if (this.shaderName == null) {
            return "";
        }
        String shName = this.shaderName.get((Object)type);
        return shName != null ? shName : "";
    }

    @Override
    public boolean equals(Object obj) {
        ShaderKey other = (ShaderKey)obj;
        if (this.name.equals(other.name) && this.getShaderName(Shader.ShaderType.Fragment).equals(other.getShaderName(Shader.ShaderType.Fragment))) {
            if (this.defines != null && other.defines != null) {
                return this.defines.equals(other.defines);
            }
            return this.defines == null && other.defines == null;
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashedCode == 0) {
            int hash = 7;
            hash = 41 * hash + this.name.hashCode();
            hash = 41 * hash + this.getShaderName(Shader.ShaderType.Fragment).hashCode();
            hash = this.getShaderName(Shader.ShaderType.Geometry) == null ? hash : 41 * hash + this.getShaderName(Shader.ShaderType.Geometry).hashCode();
            hash = this.getShaderName(Shader.ShaderType.TessellationControl) == null ? hash : 41 * hash + this.getShaderName(Shader.ShaderType.TessellationControl).hashCode();
            hash = this.getShaderName(Shader.ShaderType.TessellationEvaluation) == null ? hash : 41 * hash + this.getShaderName(Shader.ShaderType.TessellationEvaluation).hashCode();
            this.cachedHashedCode = hash = 41 * hash + (this.defines != null ? this.defines.hashCode() : 0);
        }
        return this.cachedHashedCode;
    }

    public DefineList getDefines() {
        return this.defines;
    }

    public String getVertName() {
        return this.getShaderName(Shader.ShaderType.Vertex);
    }

    public String getFragName() {
        return this.getShaderName(Shader.ShaderType.Fragment);
    }

    @Deprecated
    public String getLanguage() {
        return this.shaderLanguage.get((Object)Shader.ShaderType.Vertex);
    }

    public String getVertexShaderLanguage() {
        return this.shaderLanguage.get((Object)Shader.ShaderType.Vertex);
    }

    public String getFragmentShaderLanguage() {
        return this.shaderLanguage.get((Object)Shader.ShaderType.Vertex);
    }

    public boolean isUsesShaderNodes() {
        return this.usesShaderNodes;
    }

    public void setUsesShaderNodes(boolean usesShaderNodes) {
        this.usesShaderNodes = usesShaderNodes;
    }

    public Set<Shader.ShaderType> getUsedShaderPrograms() {
        return this.shaderName.keySet();
    }

    public String getShaderProgramLanguage(Shader.ShaderType shaderType) {
        return this.shaderLanguage.get((Object)shaderType);
    }

    public String getShaderProgramName(Shader.ShaderType shaderType) {
        return this.getShaderName(shaderType);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.shaderName.get((Object)Shader.ShaderType.Fragment), "fragment_name", null);
        oc.write(this.shaderName.get((Object)Shader.ShaderType.Geometry), "geometry_name", null);
        oc.write(this.shaderName.get((Object)Shader.ShaderType.TessellationControl), "tessControl_name", null);
        oc.write(this.shaderName.get((Object)Shader.ShaderType.TessellationEvaluation), "tessEval_name", null);
        oc.write(this.shaderLanguage.get((Object)Shader.ShaderType.Vertex), "language", null);
        oc.write(this.shaderLanguage.get((Object)Shader.ShaderType.Fragment), "frag_language", null);
        oc.write(this.shaderLanguage.get((Object)Shader.ShaderType.Geometry), "geom_language", null);
        oc.write(this.shaderLanguage.get((Object)Shader.ShaderType.TessellationControl), "tsctrl_language", null);
        oc.write(this.shaderLanguage.get((Object)Shader.ShaderType.TessellationEvaluation), "tseval_language", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.shaderName.put(Shader.ShaderType.Vertex, this.name);
        this.shaderName.put(Shader.ShaderType.Fragment, ic.readString("fragment_name", null));
        this.shaderName.put(Shader.ShaderType.Geometry, ic.readString("geometry_name", null));
        this.shaderName.put(Shader.ShaderType.TessellationControl, ic.readString("tessControl_name", null));
        this.shaderName.put(Shader.ShaderType.TessellationEvaluation, ic.readString("tessEval_name", null));
        this.shaderLanguage.put(Shader.ShaderType.Vertex, ic.readString("language", null));
        this.shaderLanguage.put(Shader.ShaderType.Fragment, ic.readString("frag_language", null));
        this.shaderLanguage.put(Shader.ShaderType.Geometry, ic.readString("geom_language", null));
        this.shaderLanguage.put(Shader.ShaderType.TessellationControl, ic.readString("tsctrl_language", null));
        this.shaderLanguage.put(Shader.ShaderType.TessellationEvaluation, ic.readString("tseval_language", null));
    }
}

