/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shadow;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingVolume;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix4f;
import com.jme3.math.Transform;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.GeometryList;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.util.TempVars;
import java.util.List;

public class ShadowUtil {
    public static void updateFrustumPoints2(Camera viewCam, Vector3f[] points) {
        int w = viewCam.getWidth();
        int h = viewCam.getHeight();
        points[0].set(viewCam.getWorldCoordinates(new Vector2f(0.0f, 0.0f), 0.0f));
        points[1].set(viewCam.getWorldCoordinates(new Vector2f(0.0f, h), 0.0f));
        points[2].set(viewCam.getWorldCoordinates(new Vector2f(w, h), 0.0f));
        points[3].set(viewCam.getWorldCoordinates(new Vector2f(w, 0.0f), 0.0f));
        points[4].set(viewCam.getWorldCoordinates(new Vector2f(0.0f, 0.0f), 1.0f));
        points[5].set(viewCam.getWorldCoordinates(new Vector2f(0.0f, h), 1.0f));
        points[6].set(viewCam.getWorldCoordinates(new Vector2f(w, h), 1.0f));
        points[7].set(viewCam.getWorldCoordinates(new Vector2f(w, 0.0f), 1.0f));
    }

    public static void updateFrustumPoints(Camera viewCam, float nearOverride, float farOverride, float scale, Vector3f[] points) {
        float far_width;
        float far_height;
        float near_width;
        float near_height;
        Vector3f pos = viewCam.getLocation();
        Vector3f dir = viewCam.getDirection();
        Vector3f up = viewCam.getUp();
        float depthHeightRatio = viewCam.getFrustumTop() / viewCam.getFrustumNear();
        float near = nearOverride;
        float far = farOverride;
        float ftop = viewCam.getFrustumTop();
        float fright = viewCam.getFrustumRight();
        float ratio = fright / ftop;
        if (viewCam.isParallelProjection()) {
            near_height = ftop;
            near_width = near_height * ratio;
            far_height = ftop;
            far_width = far_height * ratio;
        } else {
            near_height = depthHeightRatio * near;
            near_width = near_height * ratio;
            far_height = depthHeightRatio * far;
            far_width = far_height * ratio;
        }
        Vector3f right = dir.cross(up).normalizeLocal();
        Vector3f temp = new Vector3f();
        temp.set(dir).multLocal(far).addLocal(pos);
        Vector3f farCenter = temp.clone();
        temp.set(dir).multLocal(near).addLocal(pos);
        Vector3f nearCenter = temp.clone();
        Vector3f nearUp = temp.set(up).multLocal(near_height).clone();
        Vector3f farUp = temp.set(up).multLocal(far_height).clone();
        Vector3f nearRight = temp.set(right).multLocal(near_width).clone();
        Vector3f farRight = temp.set(right).multLocal(far_width).clone();
        points[0].set(nearCenter).subtractLocal(nearUp).subtractLocal(nearRight);
        points[1].set(nearCenter).addLocal(nearUp).subtractLocal(nearRight);
        points[2].set(nearCenter).addLocal(nearUp).addLocal(nearRight);
        points[3].set(nearCenter).subtractLocal(nearUp).addLocal(nearRight);
        points[4].set(farCenter).subtractLocal(farUp).subtractLocal(farRight);
        points[5].set(farCenter).addLocal(farUp).subtractLocal(farRight);
        points[6].set(farCenter).addLocal(farUp).addLocal(farRight);
        points[7].set(farCenter).subtractLocal(farUp).addLocal(farRight);
        if (scale != 1.0f) {
            Vector3f center = new Vector3f();
            for (int i = 0; i < 8; ++i) {
                center.addLocal(points[i]);
            }
            center.divideLocal(8.0f);
            Vector3f cDir = new Vector3f();
            for (int i = 0; i < 8; ++i) {
                cDir.set(points[i]).subtractLocal(center);
                cDir.multLocal(scale - 1.0f);
                points[i].addLocal(cDir);
            }
        }
    }

    public static BoundingBox computeUnionBound(GeometryList list, Transform transform) {
        BoundingBox bbox = new BoundingBox();
        TempVars tempv = TempVars.get();
        for (int i = 0; i < list.size(); ++i) {
            BoundingVolume vol = list.get(i).getWorldBound();
            BoundingVolume newVol = vol.transform(transform, (BoundingVolume)tempv.bbox);
            if (Float.isNaN(newVol.getCenter().x) || Float.isInfinite(newVol.getCenter().x)) continue;
            bbox.mergeLocal(newVol);
        }
        tempv.release();
        return bbox;
    }

    public static BoundingBox computeUnionBound(GeometryList list, Matrix4f mat) {
        BoundingBox bbox = new BoundingBox();
        TempVars tempv = TempVars.get();
        for (int i = 0; i < list.size(); ++i) {
            BoundingVolume vol = list.get(i).getWorldBound();
            BoundingVolume store = vol.transform(mat, (BoundingVolume)tempv.bbox);
            if (Float.isNaN(store.getCenter().x) || Float.isInfinite(store.getCenter().x)) continue;
            bbox.mergeLocal(store);
        }
        tempv.release();
        return bbox;
    }

    public static BoundingBox computeUnionBound(List<BoundingVolume> bv) {
        BoundingBox bbox = new BoundingBox();
        for (int i = 0; i < bv.size(); ++i) {
            BoundingVolume vol = bv.get(i);
            bbox.mergeLocal(vol);
        }
        return bbox;
    }

    public static BoundingBox computeBoundForPoints(Vector3f[] pts, Transform transform) {
        Vector3f min = new Vector3f(Vector3f.POSITIVE_INFINITY);
        Vector3f max = new Vector3f(Vector3f.NEGATIVE_INFINITY);
        Vector3f temp = new Vector3f();
        for (int i = 0; i < pts.length; ++i) {
            transform.transformVector(pts[i], temp);
            min.minLocal(temp);
            max.maxLocal(temp);
        }
        Vector3f center = min.add(max).multLocal(0.5f);
        Vector3f extent = max.subtract(min).multLocal(0.5f);
        return new BoundingBox(center, extent.x, extent.y, extent.z);
    }

    public static BoundingBox computeBoundForPoints(Vector3f[] pts, Matrix4f mat) {
        Vector3f min = new Vector3f(Vector3f.POSITIVE_INFINITY);
        Vector3f max = new Vector3f(Vector3f.NEGATIVE_INFINITY);
        TempVars vars = TempVars.get();
        Vector3f temp = vars.vect1;
        for (int i = 0; i < pts.length; ++i) {
            float w = mat.multProj(pts[i], temp);
            temp.x /= w;
            temp.y /= w;
            temp.z /= w;
            min.minLocal(temp);
            max.maxLocal(temp);
        }
        vars.release();
        Vector3f center = min.add(max).multLocal(0.5f);
        Vector3f extent = max.subtract(min).multLocal(0.5f);
        return new BoundingBox(center, extent.x + 2.0f, extent.y + 2.0f, extent.z + 2.5f);
    }

    public static void updateShadowCamera(Camera shadowCam, Vector3f[] points) {
        boolean ortho = shadowCam.isParallelProjection();
        shadowCam.setProjectionMatrix(null);
        if (ortho) {
            shadowCam.setFrustum(-1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f);
        } else {
            shadowCam.setFrustumPerspective(45.0f, 1.0f, 1.0f, 150.0f);
        }
        Matrix4f viewProjMatrix = shadowCam.getViewProjectionMatrix();
        Matrix4f projMatrix = shadowCam.getProjectionMatrix();
        BoundingBox splitBB = ShadowUtil.computeBoundForPoints(points, viewProjMatrix);
        TempVars vars = TempVars.get();
        Vector3f splitMin = splitBB.getMin(vars.vect1);
        Vector3f splitMax = splitBB.getMax(vars.vect2);
        float scaleX = 2.0f / (splitMax.x - splitMin.x);
        float scaleY = 2.0f / (splitMax.y - splitMin.y);
        float offsetX = -0.5f * (splitMax.x + splitMin.x) * scaleX;
        float offsetY = -0.5f * (splitMax.y + splitMin.y) * scaleY;
        float scaleZ = 1.0f / (splitMax.z - splitMin.z);
        float offsetZ = -splitMin.z * scaleZ;
        Matrix4f cropMatrix = vars.tempMat4;
        cropMatrix.set(scaleX, 0.0f, 0.0f, offsetX, 0.0f, scaleY, 0.0f, offsetY, 0.0f, 0.0f, scaleZ, offsetZ, 0.0f, 0.0f, 0.0f, 1.0f);
        Matrix4f result = new Matrix4f();
        result.set(cropMatrix);
        result.multLocal(projMatrix);
        vars.release();
        shadowCam.setProjectionMatrix(result);
    }

    public static void updateShadowCamera(ViewPort viewPort, GeometryList receivers, Camera shadowCam, Vector3f[] points, GeometryList splitOccluders, float shadowMapSize) {
        boolean ortho = shadowCam.isParallelProjection();
        shadowCam.setProjectionMatrix(null);
        if (ortho) {
            shadowCam.setFrustum(-1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f);
        }
        Matrix4f viewProjMatrix = shadowCam.getViewProjectionMatrix();
        BoundingBox splitBB = ShadowUtil.computeBoundForPoints(points, viewProjMatrix);
        TempVars vars = TempVars.get();
        BoundingBox casterBB = new BoundingBox();
        BoundingBox receiverBB = new BoundingBox();
        int casterCount = 0;
        int receiverCount = 0;
        for (int i = 0; i < receivers.size(); ++i) {
            Geometry receiver = receivers.get(i);
            BoundingVolume bv = receiver.getWorldBound();
            BoundingVolume recvBox = bv.transform(viewProjMatrix, (BoundingVolume)vars.bbox);
            if (!splitBB.intersects(recvBox) || Float.isNaN(recvBox.getCenter().x) || Float.isInfinite(recvBox.getCenter().x)) continue;
            receiverBB.mergeLocal(recvBox);
            ++receiverCount;
        }
        OccludersExtractor occExt = new OccludersExtractor(viewProjMatrix, casterCount, splitBB, casterBB, splitOccluders, vars);
        for (Spatial scene : viewPort.getScenes()) {
            occExt.addOccluders(scene);
        }
        casterCount = occExt.casterCount;
        if (casterCount != receiverCount) {
            casterBB.setXExtent(casterBB.getXExtent() + 2.0f);
            casterBB.setYExtent(casterBB.getYExtent() + 2.0f);
            casterBB.setZExtent(casterBB.getZExtent() + 2.0f);
        }
        Vector3f casterMin = casterBB.getMin(vars.vect1);
        Vector3f casterMax = casterBB.getMax(vars.vect2);
        Vector3f receiverMin = receiverBB.getMin(vars.vect3);
        Vector3f receiverMax = receiverBB.getMax(vars.vect4);
        Vector3f splitMin = splitBB.getMin(vars.vect5);
        Vector3f splitMax = splitBB.getMax(vars.vect6);
        splitMin.z = 0.0f;
        Matrix4f projMatrix = shadowCam.getProjectionMatrix();
        Vector3f cropMin = vars.vect7;
        Vector3f cropMax = vars.vect8;
        cropMin.x = Math.max(Math.max(casterMin.x, receiverMin.x), splitMin.x);
        cropMax.x = Math.min(Math.min(casterMax.x, receiverMax.x), splitMax.x);
        cropMin.y = Math.max(Math.max(casterMin.y, receiverMin.y), splitMin.y);
        cropMax.y = Math.min(Math.min(casterMax.y, receiverMax.y), splitMax.y);
        cropMin.z = Math.min(casterMin.z, splitMin.z);
        cropMax.z = Math.min(receiverMax.z, splitMax.z);
        float scaleX = 2.0f / (cropMax.x - cropMin.x);
        float scaleY = 2.0f / (cropMax.y - cropMin.y);
        float halfTextureSize = shadowMapSize * 0.5f;
        if (halfTextureSize != 0.0f && scaleX > 0.0f && scaleY > 0.0f) {
            float scaleQuantizer = 0.1f;
            scaleX = 1.0f / FastMath.ceil(1.0f / scaleX * scaleQuantizer) * scaleQuantizer;
            scaleY = 1.0f / FastMath.ceil(1.0f / scaleY * scaleQuantizer) * scaleQuantizer;
        }
        float offsetX = -0.5f * (cropMax.x + cropMin.x) * scaleX;
        float offsetY = -0.5f * (cropMax.y + cropMin.y) * scaleY;
        if (halfTextureSize != 0.0f && scaleX > 0.0f && scaleY > 0.0f) {
            offsetX = FastMath.ceil(offsetX * halfTextureSize) / halfTextureSize;
            offsetY = FastMath.ceil(offsetY * halfTextureSize) / halfTextureSize;
        }
        float scaleZ = 1.0f / (cropMax.z - cropMin.z);
        float offsetZ = -cropMin.z * scaleZ;
        Matrix4f cropMatrix = vars.tempMat4;
        cropMatrix.set(scaleX, 0.0f, 0.0f, offsetX, 0.0f, scaleY, 0.0f, offsetY, 0.0f, 0.0f, scaleZ, offsetZ, 0.0f, 0.0f, 0.0f, 1.0f);
        Matrix4f result = new Matrix4f();
        result.set(cropMatrix);
        result.multLocal(projMatrix);
        vars.release();
        shadowCam.setProjectionMatrix(result);
    }

    public static void getGeometriesInCamFrustum(GeometryList inputGeometryList, Camera camera, GeometryList outputGeometryList) {
        for (int i = 0; i < inputGeometryList.size(); ++i) {
            Geometry g = inputGeometryList.get(i);
            int planeState = camera.getPlaneState();
            camera.setPlaneState(0);
            if (camera.contains(g.getWorldBound()) != Camera.FrustumIntersect.Outside) {
                outputGeometryList.add(g);
            }
            camera.setPlaneState(planeState);
        }
    }

    public static void getGeometriesInCamFrustum(Spatial rootScene, Camera camera, RenderQueue.ShadowMode mode, GeometryList outputGeometryList) {
        if (rootScene != null && rootScene instanceof Node) {
            int planeState = camera.getPlaneState();
            ShadowUtil.addGeometriesInCamFrustumFromNode(camera, (Node)rootScene, mode, outputGeometryList);
            camera.setPlaneState(planeState);
        }
    }

    private static boolean checkShadowMode(RenderQueue.ShadowMode shadowMode, RenderQueue.ShadowMode desired) {
        if (shadowMode != RenderQueue.ShadowMode.Off) {
            switch (desired) {
                case Cast: {
                    return shadowMode == RenderQueue.ShadowMode.Cast || shadowMode == RenderQueue.ShadowMode.CastAndReceive;
                }
                case Receive: {
                    return shadowMode == RenderQueue.ShadowMode.Receive || shadowMode == RenderQueue.ShadowMode.CastAndReceive;
                }
                case CastAndReceive: {
                    return true;
                }
            }
        }
        return false;
    }

    private static void addGeometriesInCamFrustumFromNode(Camera camera, Node scene, RenderQueue.ShadowMode mode, GeometryList outputGeometryList) {
        if (scene.getCullHint() == Spatial.CullHint.Always) {
            return;
        }
        camera.setPlaneState(0);
        if (camera.contains(scene.getWorldBound()) != Camera.FrustumIntersect.Outside) {
            for (Spatial child : scene.getChildren()) {
                if (child instanceof Node) {
                    ShadowUtil.addGeometriesInCamFrustumFromNode(camera, (Node)child, mode, outputGeometryList);
                    continue;
                }
                if (!(child instanceof Geometry) || child.getCullHint() == Spatial.CullHint.Always) continue;
                camera.setPlaneState(0);
                if (!ShadowUtil.checkShadowMode(child.getShadowMode(), mode) || ((Geometry)child).isGrouped() || camera.contains(child.getWorldBound()) == Camera.FrustumIntersect.Outside) continue;
                outputGeometryList.add((Geometry)child);
            }
        }
    }

    public static void getGeometriesInLightRadius(GeometryList inputGeometryList, Camera[] cameras, GeometryList outputGeometryList) {
        for (int i = 0; i < inputGeometryList.size(); ++i) {
            Geometry g = inputGeometryList.get(i);
            boolean inFrustum = false;
            for (int j = 0; j < cameras.length && !inFrustum; ++j) {
                Camera camera = cameras[j];
                int planeState = camera.getPlaneState();
                camera.setPlaneState(0);
                inFrustum = camera.contains(g.getWorldBound()) != Camera.FrustumIntersect.Outside;
                camera.setPlaneState(planeState);
            }
            if (!inFrustum) continue;
            outputGeometryList.add(g);
        }
    }

    public static void getLitGeometriesInViewPort(Spatial rootScene, Camera vpCamera, Camera[] cameras, RenderQueue.ShadowMode mode, GeometryList outputGeometryList) {
        if (rootScene != null && rootScene instanceof Node) {
            ShadowUtil.addGeometriesInCamFrustumAndViewPortFromNode(vpCamera, cameras, (Node)rootScene, mode, outputGeometryList);
        }
    }

    private static void addGeometriesInCamFrustumAndViewPortFromNode(Camera vpCamera, Camera[] cameras, Spatial scene, RenderQueue.ShadowMode mode, GeometryList outputGeometryList) {
        if (scene.getCullHint() == Spatial.CullHint.Always) {
            return;
        }
        boolean inFrustum = false;
        for (int j = 0; j < cameras.length && !inFrustum; ++j) {
            Camera camera = cameras[j];
            int planeState = camera.getPlaneState();
            camera.setPlaneState(0);
            inFrustum = camera.contains(scene.getWorldBound()) != Camera.FrustumIntersect.Outside && scene.checkCulling(vpCamera);
            camera.setPlaneState(planeState);
        }
        if (inFrustum) {
            if (scene instanceof Node) {
                Node node = (Node)scene;
                for (Spatial child : node.getChildren()) {
                    ShadowUtil.addGeometriesInCamFrustumAndViewPortFromNode(vpCamera, cameras, child, mode, outputGeometryList);
                }
            } else if (scene instanceof Geometry && ShadowUtil.checkShadowMode(scene.getShadowMode(), mode) && !((Geometry)scene).isGrouped()) {
                outputGeometryList.add((Geometry)scene);
            }
        }
    }

    public static class OccludersExtractor {
        Matrix4f viewProjMatrix;
        public Integer casterCount;
        BoundingBox splitBB;
        BoundingBox casterBB;
        GeometryList splitOccluders;
        TempVars vars;

        public OccludersExtractor() {
        }

        public OccludersExtractor(Matrix4f vpm, int cc, BoundingBox sBB, BoundingBox cBB, GeometryList sOCC, TempVars v) {
            this.viewProjMatrix = vpm;
            this.casterCount = cc;
            this.splitBB = sBB;
            this.casterBB = cBB;
            this.splitOccluders = sOCC;
            this.vars = v;
        }

        public int addOccluders(Spatial scene) {
            if (scene != null) {
                this.process(scene);
            }
            return this.casterCount;
        }

        private void process(Spatial scene) {
            block7: {
                block6: {
                    boolean intersects;
                    BoundingVolume occBox;
                    Geometry occluder;
                    block8: {
                        if (scene.getCullHint() == Spatial.CullHint.Always) {
                            return;
                        }
                        RenderQueue.ShadowMode shadowMode = scene.getShadowMode();
                        if (!(scene instanceof Geometry)) break block6;
                        occluder = (Geometry)scene;
                        if (shadowMode == RenderQueue.ShadowMode.Off || shadowMode == RenderQueue.ShadowMode.Receive || occluder.isGrouped() || occluder.getWorldBound() == null) break block7;
                        BoundingVolume bv = occluder.getWorldBound();
                        occBox = bv.transform(this.viewProjMatrix, (BoundingVolume)this.vars.bbox);
                        intersects = this.splitBB.intersects(occBox);
                        if (intersects || !(occBox instanceof BoundingBox)) break block8;
                        BoundingBox occBB = (BoundingBox)occBox;
                        occBB.setZExtent(occBB.getZExtent() + 50.0f);
                        occBB.setCenter(occBB.getCenter().addLocal(0.0f, 0.0f, 25.0f));
                        if (!this.splitBB.intersects(occBB)) break block7;
                        if (!Float.isNaN(occBox.getCenter().x) && !Float.isInfinite(occBox.getCenter().x)) {
                            occBB.setZExtent(occBB.getZExtent() - 50.0f);
                            occBB.setCenter(occBB.getCenter().subtractLocal(0.0f, 0.0f, 25.0f));
                            this.casterBB.mergeLocal(occBox);
                            Integer n = this.casterCount;
                            Integer n2 = this.casterCount = Integer.valueOf(this.casterCount + 1);
                        }
                        if (this.splitOccluders == null) break block7;
                        this.splitOccluders.add(occluder);
                        break block7;
                    }
                    if (!intersects) break block7;
                    this.casterBB.mergeLocal(occBox);
                    Integer occBB = this.casterCount;
                    Integer n = this.casterCount = Integer.valueOf(this.casterCount + 1);
                    if (this.splitOccluders == null) break block7;
                    this.splitOccluders.add(occluder);
                    break block7;
                }
                if (scene instanceof Node && ((Node)scene).getWorldBound() != null) {
                    Node nodeOcc = (Node)scene;
                    boolean intersects = false;
                    BoundingVolume bv = nodeOcc.getWorldBound();
                    BoundingVolume occBox = bv.transform(this.viewProjMatrix, (BoundingVolume)this.vars.bbox);
                    intersects = this.splitBB.intersects(occBox);
                    if (!intersects && occBox instanceof BoundingBox) {
                        BoundingBox occBB = (BoundingBox)occBox;
                        occBB.setZExtent(occBB.getZExtent() + 50.0f);
                        occBB.setCenter(occBB.getCenter().addLocal(0.0f, 0.0f, 25.0f));
                        intersects = this.splitBB.intersects(occBB);
                    }
                    if (intersects) {
                        for (Spatial child : ((Node)scene).getChildren()) {
                            this.process(child);
                        }
                    }
                }
            }
        }
    }
}

