/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.ogg;

import de.jarnbjo.ogg.EndOfOggStreamException;
import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.ogg.LogicalOggStreamImpl;
import de.jarnbjo.ogg.OggFormatException;
import de.jarnbjo.ogg.OggPage;
import de.jarnbjo.ogg.PhysicalOggStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;

public class UncachedUrlStream
implements PhysicalOggStream {
    private boolean closed = false;
    private URLConnection source;
    private InputStream sourceStream;
    private Object drainLock = new Object();
    private LinkedList pageCache = new LinkedList();
    private long numberOfSamples = -1L;
    private HashMap logicalStreams = new HashMap();
    private LoaderThread loaderThread;
    private static final int PAGECACHE_SIZE = 10;

    public UncachedUrlStream(URL source) throws OggFormatException, IOException {
        this.source = source.openConnection();
        this.sourceStream = this.source.getInputStream();
        this.loaderThread = new LoaderThread(this.sourceStream, this.pageCache);
        new Thread(this.loaderThread).start();
        while (!this.loaderThread.isBosDone() || this.pageCache.size() < 10) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public Collection getLogicalStreams() {
        return this.logicalStreams.values();
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public void close() throws IOException {
        this.closed = true;
        this.sourceStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OggPage getOggPage(int index) throws IOException {
        while (this.pageCache.size() == 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Object object = this.drainLock;
        synchronized (object) {
            return (OggPage)this.pageCache.removeFirst();
        }
    }

    private LogicalOggStream getLogicalStream(int serialNumber) {
        return (LogicalOggStream)this.logicalStreams.get(new Integer(serialNumber));
    }

    public void setTime(long granulePosition) throws IOException {
        throw new UnsupportedOperationException("Method not supported by this class");
    }

    public boolean isSeekable() {
        return false;
    }

    public class LoaderThread
    implements Runnable {
        private InputStream source;
        private LinkedList pageCache;
        private RandomAccessFile drain;
        private byte[] memoryCache;
        private boolean bosDone = false;
        private int pageNumber;

        public LoaderThread(InputStream source, LinkedList pageCache) {
            this.source = source;
            this.pageCache = pageCache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                boolean eos = false;
                byte[] buffer = new byte[8192];
                while (!eos) {
                    LogicalOggStreamImpl los;
                    OggPage op = OggPage.create(this.source);
                    Object object = UncachedUrlStream.this.drainLock;
                    synchronized (object) {
                        this.pageCache.add(op);
                    }
                    if (!op.isBos()) {
                        this.bosDone = true;
                    }
                    if (op.isEos()) {
                        eos = true;
                    }
                    if ((los = (LogicalOggStreamImpl)UncachedUrlStream.this.getLogicalStream(op.getStreamSerialNumber())) == null) {
                        los = new LogicalOggStreamImpl(UncachedUrlStream.this, op.getStreamSerialNumber());
                        UncachedUrlStream.this.logicalStreams.put(new Integer(op.getStreamSerialNumber()), los);
                        los.checkFormat(op);
                    }
                    ++this.pageNumber;
                    while (this.pageCache.size() > 10) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException ex) {}
                    }
                }
            }
            catch (EndOfOggStreamException e) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public boolean isBosDone() {
            return this.bosDone;
        }
    }
}

