/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.oggtools;

import de.jarnbjo.ogg.EndOfOggStreamException;
import de.jarnbjo.ogg.FileStream;
import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.vorbis.CommentHeader;
import de.jarnbjo.vorbis.VorbisStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Ogg2Wav {
    private static final int BUFFER_SIZE = 65536;

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: java -jar Ogg2Wav.jar in.ogg out.wav");
            System.exit(0);
        }
        try {
            FileStream os = new FileStream(new RandomAccessFile(args[0], "r"));
            LogicalOggStream los = (LogicalOggStream)os.getLogicalStreams().iterator().next();
            if (los.getFormat() != "audio/x-vorbis") {
                System.out.println("This tool only supports Ogg files with Vorbis content.");
                System.exit(0);
            }
            long t0 = System.currentTimeMillis();
            VorbisStream vs = new VorbisStream(los);
            RandomAccessFile outFile = new RandomAccessFile(args[1], "rw");
            outFile.setLength(0L);
            byte[] buffer = new byte[65536];
            int len = 0;
            int channels = vs.getIdentificationHeader().getChannels();
            int sampleRate = vs.getIdentificationHeader().getSampleRate();
            CommentHeader comments = vs.getCommentHeader();
            System.out.println("Ogg file:       " + args[0]);
            System.out.println("Wav file:       " + args[1]);
            System.out.println();
            System.out.println("Channels:       " + channels);
            System.out.println("Sample rate:    " + sampleRate);
            System.out.println();
            System.out.println("Encoder vendor: " + comments.getVendor());
            System.out.println("Title:          " + Ogg2Wav.format(comments.getTitle()));
            System.out.println("Artist:         " + Ogg2Wav.format(comments.getArtist()));
            outFile.write("RIFF".getBytes("ASCII"));
            outFile.write(Ogg2Wav.toBytes(0));
            outFile.write("WAVE".getBytes("ASCII"));
            outFile.write("fmt ".getBytes("ASCII"));
            outFile.write(Ogg2Wav.toBytes(16));
            outFile.write(Ogg2Wav.toBytes((short)1));
            outFile.write(Ogg2Wav.toBytes((short)channels));
            outFile.write(Ogg2Wav.toBytes(sampleRate));
            outFile.write(Ogg2Wav.toBytes(sampleRate * channels * 2));
            outFile.write(Ogg2Wav.toBytes((short)(2 * channels)));
            outFile.write(Ogg2Wav.toBytes((short)16));
            outFile.write("data".getBytes("ASCII"));
            outFile.write(Ogg2Wav.toBytes(0));
            try {
                while (true) {
                    int read = vs.readPcm(buffer, 0, buffer.length);
                    for (int i = 0; i < read; i += 2) {
                        byte tB = buffer[i];
                        buffer[i] = buffer[i + 1];
                        buffer[i + 1] = tB;
                    }
                    outFile.write(buffer, 0, read);
                    len += read;
                }
            }
            catch (EndOfOggStreamException e) {
                outFile.seek(4L);
                outFile.write(Ogg2Wav.toBytes(len + 36));
                outFile.seek(40L);
                outFile.write(Ogg2Wav.toBytes(len));
                outFile.close();
                os.close();
                System.out.println(System.currentTimeMillis() - t0);
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("The ogg file \"" + args[0] + "\" was not found.");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Error: ");
            System.out.println(e.getMessage());
        }
    }

    private static String format(String s) {
        return s == null ? "<unknown>" : s;
    }

    private static byte[] toBytes(int val) {
        byte[] res = new byte[4];
        res[3] = (byte)(0xFF & val >> 24);
        res[2] = (byte)(0xFF & val >> 16);
        res[1] = (byte)(0xFF & val >> 8);
        res[0] = (byte)(0xFF & val);
        return res;
    }

    private static byte[] toBytes(short val) {
        byte[] res = new byte[2];
        res[1] = (byte)(0xFF & val >> 8);
        res[0] = (byte)(0xFF & val);
        return res;
    }
}

