/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.water;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Plane;
import com.jme3.math.Quaternion;
import com.jme3.math.Ray;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.ui.Picture;
import com.jme3.water.ReflectionProcessor;
import com.jme3.water.WaterUtils;

public class SimpleWaterProcessor
implements SceneProcessor {
    protected RenderManager rm;
    protected ViewPort vp;
    protected Spatial reflectionScene;
    protected ViewPort reflectionView;
    protected ViewPort refractionView;
    protected FrameBuffer reflectionBuffer;
    protected FrameBuffer refractionBuffer;
    protected Camera reflectionCam;
    protected Camera refractionCam;
    protected Texture2D reflectionTexture;
    protected Texture2D refractionTexture;
    protected Texture2D depthTexture;
    protected Texture2D normalTexture;
    protected Texture2D dudvTexture;
    protected int renderWidth = 512;
    protected int renderHeight = 512;
    protected Plane plane = new Plane(Vector3f.UNIT_Y, Vector3f.ZERO.dot(Vector3f.UNIT_Y));
    protected float speed = 0.05f;
    protected Ray ray = new Ray();
    protected Vector3f targetLocation = new Vector3f();
    protected AssetManager manager;
    protected Material material;
    protected float waterDepth = 1.0f;
    protected float waterTransparency = 0.4f;
    protected boolean debug = false;
    private Picture dispRefraction;
    private Picture dispReflection;
    private Picture dispDepth;
    private Plane reflectionClipPlane;
    private Plane refractionClipPlane;
    private float refractionClippingOffset = 0.3f;
    private float reflectionClippingOffset = -5.0f;
    private float distortionScale = 0.2f;
    private float distortionMix = 0.5f;
    private float texScale = 1.0f;
    float time = 0.0f;
    float savedTpf = 0.0f;

    public SimpleWaterProcessor(AssetManager manager) {
        this.manager = manager;
        this.material = new Material(manager, "Common/MatDefs/Water/SimpleWater.j3md");
        this.material.setFloat("waterDepth", this.waterDepth);
        this.material.setFloat("waterTransparency", this.waterTransparency / 10.0f);
        this.material.setColor("waterColor", ColorRGBA.White);
        this.material.setVector3("lightPos", new Vector3f(1.0f, -1.0f, 1.0f));
        this.material.setFloat("distortionScale", this.distortionScale);
        this.material.setFloat("distortionMix", this.distortionMix);
        this.material.setFloat("texScale", this.texScale);
        this.updateClipPlanes();
    }

    public void initialize(RenderManager rm, ViewPort vp) {
        this.rm = rm;
        this.vp = vp;
        this.loadTextures(this.manager);
        this.createTextures();
        this.applyTextures(this.material);
        this.createPreViews();
        this.material.setVector2("FrustumNearFar", new Vector2f(vp.getCamera().getFrustumNear(), vp.getCamera().getFrustumFar()));
        if (this.debug) {
            this.dispRefraction = new Picture("dispRefraction");
            this.dispRefraction.setTexture(this.manager, this.refractionTexture, false);
            this.dispReflection = new Picture("dispRefraction");
            this.dispReflection.setTexture(this.manager, this.reflectionTexture, false);
            this.dispDepth = new Picture("depthTexture");
            this.dispDepth.setTexture(this.manager, this.depthTexture, false);
        }
    }

    public void reshape(ViewPort vp, int w, int h) {
    }

    public boolean isInitialized() {
        return this.rm != null;
    }

    public void preFrame(float tpf) {
        this.time += tpf * this.speed;
        if (this.time > 1.0f) {
            this.time = 0.0f;
        }
        this.material.setFloat("time", this.time);
        this.savedTpf = tpf;
    }

    public void postQueue(RenderQueue rq) {
        Camera sceneCam = this.rm.getCurrentCamera();
        this.refractionCam.setLocation(sceneCam.getLocation());
        this.refractionCam.setRotation(sceneCam.getRotation());
        this.refractionCam.setFrustum(sceneCam.getFrustumNear(), sceneCam.getFrustumFar(), sceneCam.getFrustumLeft(), sceneCam.getFrustumRight(), sceneCam.getFrustumTop(), sceneCam.getFrustumBottom());
        this.refractionCam.setParallelProjection(sceneCam.isParallelProjection());
        WaterUtils.updateReflectionCam(this.reflectionCam, this.plane, sceneCam);
        this.rm.renderViewPort(this.reflectionView, this.savedTpf);
        this.rm.renderViewPort(this.refractionView, this.savedTpf);
        this.rm.getRenderer().setFrameBuffer(this.vp.getOutputFrameBuffer());
        this.rm.setCamera(sceneCam, false);
    }

    public void postFrame(FrameBuffer out) {
        if (this.debug) {
            this.displayMap(this.rm.getRenderer(), this.dispRefraction, 64);
            this.displayMap(this.rm.getRenderer(), this.dispReflection, 256);
            this.displayMap(this.rm.getRenderer(), this.dispDepth, 448);
        }
    }

    public void cleanup() {
    }

    protected void displayMap(Renderer r, Picture pic, int left) {
        Camera cam = this.vp.getCamera();
        this.rm.setCamera(cam, true);
        int h = cam.getHeight();
        pic.setPosition((float)left, (float)h / 20.0f);
        pic.setWidth(128.0f);
        pic.setHeight(128.0f);
        pic.updateGeometricState();
        this.rm.renderGeometry((Geometry)pic);
        this.rm.setCamera(cam, false);
    }

    protected void loadTextures(AssetManager manager) {
        this.normalTexture = (Texture2D)manager.loadTexture("Common/MatDefs/Water/Textures/water_normalmap.png");
        this.dudvTexture = (Texture2D)manager.loadTexture("Common/MatDefs/Water/Textures/dudv_map.jpg");
        this.normalTexture.setWrap(Texture.WrapMode.Repeat);
        this.dudvTexture.setWrap(Texture.WrapMode.Repeat);
    }

    protected void createTextures() {
        this.reflectionTexture = new Texture2D(this.renderWidth, this.renderHeight, Image.Format.RGBA8);
        this.refractionTexture = new Texture2D(this.renderWidth, this.renderHeight, Image.Format.RGBA8);
        this.reflectionTexture.setMinFilter(Texture.MinFilter.Trilinear);
        this.reflectionTexture.setMagFilter(Texture.MagFilter.Bilinear);
        this.refractionTexture.setMinFilter(Texture.MinFilter.Trilinear);
        this.refractionTexture.setMagFilter(Texture.MagFilter.Bilinear);
        this.depthTexture = new Texture2D(this.renderWidth, this.renderHeight, Image.Format.Depth);
    }

    protected void applyTextures(Material mat) {
        mat.setTexture("water_reflection", (Texture)this.reflectionTexture);
        mat.setTexture("water_refraction", (Texture)this.refractionTexture);
        mat.setTexture("water_depthmap", (Texture)this.depthTexture);
        mat.setTexture("water_normalmap", (Texture)this.normalTexture);
        mat.setTexture("water_dudvmap", (Texture)this.dudvTexture);
    }

    protected void createPreViews() {
        this.reflectionCam = new Camera(this.renderWidth, this.renderHeight);
        this.refractionCam = new Camera(this.renderWidth, this.renderHeight);
        this.reflectionView = new ViewPort("Reflection View", this.reflectionCam);
        this.reflectionView.setClearFlags(true, true, true);
        this.reflectionView.setBackgroundColor(ColorRGBA.Black);
        this.reflectionBuffer = new FrameBuffer(this.renderWidth, this.renderHeight, 1);
        this.reflectionBuffer.setDepthBuffer(Image.Format.Depth);
        this.reflectionBuffer.setColorTexture(this.reflectionTexture);
        this.reflectionView.setOutputFrameBuffer(this.reflectionBuffer);
        this.reflectionView.addProcessor((SceneProcessor)new ReflectionProcessor(this.reflectionCam, this.reflectionBuffer, this.reflectionClipPlane));
        this.reflectionView.attachScene(this.reflectionScene);
        this.refractionView = new ViewPort("Refraction View", this.refractionCam);
        this.refractionView.setClearFlags(true, true, true);
        this.refractionView.setBackgroundColor(ColorRGBA.Black);
        this.refractionBuffer = new FrameBuffer(this.renderWidth, this.renderHeight, 1);
        this.refractionBuffer.setDepthBuffer(Image.Format.Depth);
        this.refractionBuffer.setColorTexture(this.refractionTexture);
        this.refractionBuffer.setDepthTexture(this.depthTexture);
        this.refractionView.setOutputFrameBuffer(this.refractionBuffer);
        this.refractionView.addProcessor((SceneProcessor)new RefractionProcessor());
        this.refractionView.attachScene(this.reflectionScene);
    }

    protected void destroyViews() {
        this.rm.removePreView(this.refractionView);
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setReflectionScene(Spatial spat) {
        this.reflectionScene = spat;
    }

    public int getRenderWidth() {
        return this.renderWidth;
    }

    public int getRenderHeight() {
        return this.renderHeight;
    }

    public void setRenderSize(int width, int height) {
        this.renderWidth = width;
        this.renderHeight = height;
    }

    public Plane getPlane() {
        return this.plane;
    }

    public void setPlane(Plane plane) {
        this.plane.setConstant(plane.getConstant());
        this.plane.setNormal(plane.getNormal());
        this.updateClipPlanes();
    }

    public void setPlane(Vector3f origin, Vector3f normal) {
        this.plane.setOriginNormal(origin, normal);
        this.updateClipPlanes();
    }

    private void updateClipPlanes() {
        this.reflectionClipPlane = this.plane.clone();
        this.reflectionClipPlane.setConstant(this.reflectionClipPlane.getConstant() + this.reflectionClippingOffset);
        this.refractionClipPlane = this.plane.clone();
        this.refractionClipPlane.setConstant(this.refractionClipPlane.getConstant() + this.refractionClippingOffset);
    }

    public void setLightPosition(Vector3f position) {
        this.material.setVector3("lightPos", position);
    }

    public void setWaterColor(ColorRGBA color) {
        this.material.setColor("waterColor", color);
    }

    public void setWaterDepth(float depth) {
        this.waterDepth = depth;
        this.material.setFloat("waterDepth", depth);
    }

    public float getWaterDepth() {
        return this.waterDepth;
    }

    public float getWaterTransparency() {
        return this.waterTransparency;
    }

    public void setWaterTransparency(float waterTransparency) {
        this.waterTransparency = Math.max(0.0f, waterTransparency);
        this.material.setFloat("waterTransparency", waterTransparency / 10.0f);
    }

    public void setWaveSpeed(float speed) {
        this.speed = speed;
    }

    public float getWaveSpeed() {
        return this.speed;
    }

    public void setDistortionScale(float value) {
        this.distortionScale = value;
        this.material.setFloat("distortionScale", this.distortionScale);
    }

    public void setDistortionMix(float value) {
        this.distortionMix = value;
        this.material.setFloat("distortionMix", this.distortionMix);
    }

    public void setTexScale(float value) {
        this.texScale = value;
        this.material.setFloat("texScale", this.texScale);
    }

    public float getDistortionScale() {
        return this.distortionScale;
    }

    public float getDistortionMix() {
        return this.distortionMix;
    }

    public float getTexScale() {
        return this.texScale;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public Geometry createWaterGeometry(float width, float height) {
        Quad quad = new Quad(width, height);
        Geometry geom = new Geometry("WaterGeometry", (Mesh)quad);
        geom.setLocalRotation(new Quaternion().fromAngleAxis(-1.5707964f, Vector3f.UNIT_X));
        geom.setMaterial(this.material);
        return geom;
    }

    public float getReflectionClippingOffset() {
        return this.reflectionClippingOffset;
    }

    public void setReflectionClippingOffset(float reflectionClippingOffset) {
        this.reflectionClippingOffset = reflectionClippingOffset;
        this.updateClipPlanes();
    }

    public float getRefractionClippingOffset() {
        return this.refractionClippingOffset;
    }

    public void setRefractionClippingOffset(float refractionClippingOffset) {
        this.refractionClippingOffset = refractionClippingOffset;
        this.updateClipPlanes();
    }

    public class RefractionProcessor
    implements SceneProcessor {
        RenderManager rm;
        ViewPort vp;

        public void initialize(RenderManager rm, ViewPort vp) {
            this.rm = rm;
            this.vp = vp;
        }

        public void reshape(ViewPort vp, int w, int h) {
        }

        public boolean isInitialized() {
            return this.rm != null;
        }

        public void preFrame(float tpf) {
            SimpleWaterProcessor.this.refractionCam.setClipPlane(SimpleWaterProcessor.this.refractionClipPlane, Plane.Side.Negative);
        }

        public void postQueue(RenderQueue rq) {
        }

        public void postFrame(FrameBuffer out) {
        }

        public void cleanup() {
        }
    }
}

