/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.app.state.BaseAppState;
import com.jme3.util.SafeArrayList;

public class CompositeAppState
extends BaseAppState {
    private final SafeArrayList<AppStateEntry> states = new SafeArrayList<AppStateEntry>(AppStateEntry.class);
    private boolean childrenEnabled;
    private boolean attached;

    public CompositeAppState(AppState ... states) {
        for (AppState a : states) {
            this.states.add(new AppStateEntry(a));
        }
    }

    private int indexOf(AppState state) {
        for (int i = 0; i < this.states.size(); ++i) {
            AppStateEntry e = this.states.get(i);
            if (e.state != state) continue;
            return i;
        }
        return -1;
    }

    private AppStateEntry entry(AppState state) {
        for (int i = 0; i < this.states.size(); ++i) {
            AppStateEntry e = this.states.get(i);
            if (e.state != state) continue;
            return e;
        }
        return null;
    }

    protected <T extends AppState> T addChild(T state) {
        if (this.indexOf(state) >= 0) {
            return state;
        }
        this.states.add(new AppStateEntry(state));
        if (this.attached) {
            this.getApplication().getStateManager().attach(state);
        }
        return state;
    }

    protected void removeChild(AppState state) {
        int index = this.indexOf(state);
        if (index < 0) {
            return;
        }
        this.states.remove(index);
        if (this.attached) {
            this.getApplication().getStateManager().detach(state);
        }
    }

    protected <T extends AppState> T getChild(Class<T> stateType) {
        for (AppStateEntry e : this.states) {
            if (!stateType.isInstance(e.state)) continue;
            return (T)((AppState)stateType.cast(e.state));
        }
        return null;
    }

    @Override
    public void stateAttached(AppStateManager stateManager) {
        for (AppStateEntry e : this.states.getArray()) {
            stateManager.attach(e.state);
        }
        this.attached = true;
    }

    @Override
    public void stateDetached(AppStateManager stateManager) {
        for (int i = this.states.size() - 1; i >= 0; --i) {
            stateManager.detach(this.states.get((int)i).state);
        }
        this.attached = false;
    }

    protected void setChildrenEnabled(boolean b) {
        if (this.childrenEnabled == b) {
            return;
        }
        this.childrenEnabled = b;
        for (AppStateEntry e : this.states.getArray()) {
            if (e.override) {
                if (b) {
                    e.state.setEnabled(e.enabled);
                    continue;
                }
                e.state.setEnabled(false);
                continue;
            }
            e.state.setEnabled(b);
        }
    }

    public void setOverrideEnabled(AppState state, boolean enabled, boolean override) {
        AppStateEntry e = this.entry(state);
        if (e == null) {
            throw new IllegalArgumentException("State not managed:" + state);
        }
        if (override) {
            e.override = true;
            e.enabled = enabled;
            e.state.setEnabled(enabled);
        } else {
            e.override = false;
            e.enabled = this.isEnabled();
            e.state.setEnabled(this.isEnabled());
        }
    }

    @Override
    protected void initialize(Application app) {
    }

    @Override
    protected void cleanup(Application app) {
    }

    @Override
    protected void onEnable() {
        this.setChildrenEnabled(true);
    }

    @Override
    protected void onDisable() {
        this.setChildrenEnabled(false);
    }

    private class AppStateEntry {
        AppState state;
        boolean enabled;
        boolean override;

        public AppStateEntry(AppState state) {
            this.state = state;
            this.enabled = state.isEnabled();
        }
    }
}

