/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.input.event.JoyButtonEvent;
import com.jme3.input.event.KeyInputEvent;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.TouchEvent;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.anim.AnimationState;
import com.simsilica.lemur.anim.PanelTweens;
import com.simsilica.lemur.anim.SpatialTweens;
import com.simsilica.lemur.anim.Tween;
import com.simsilica.lemur.anim.TweenAnimation;
import com.simsilica.lemur.anim.Tweens;
import com.simsilica.lemur.component.IconComponent;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.event.DefaultRawInputListener;
import com.simsilica.mattacks.Main;
import com.simsilica.mattacks.MainMenuState;
import com.simsilica.mattacks.SoundState;
import com.simsilica.mattacks.StarFieldState;

public class IntroductionState
extends BaseAppState {
    private AnimationState anim;
    private Node root;
    private Spatial logo;
    private Label presented;
    private Label simsilica;
    private Panel block;
    private TweenAnimation introAnim;
    private final InterruptListener interruptListener = new InterruptListener();
    private boolean interrupting = false;

    @Override
    protected void initialize(Application app) {
        this.anim = this.getState(AnimationState.class);
        this.getState(StarFieldState.class).setAlpha(0.0f);
        this.logo = app.getAssetManager().loadModel("Models/simsilica.j3o");
        this.logo.center();
        this.simsilica = new Label("");
        IconComponent icon = new IconComponent("Interface/Simsilica-text1024.png");
        icon.setColor(new ColorRGBA(0.5f, 0.9f, 1.0f, 1.0f).mult(1.5f));
        this.simsilica.setIcon(icon);
        float scale = 0.025f;
        this.simsilica.setLocalScale(scale);
        Vector3f pref = this.simsilica.getPreferredSize();
        this.simsilica.setLocalTranslation(-pref.x * 0.5f * scale, -6.0f, 0.0f);
        this.root = new Node("logo root");
        this.root.attachChild(this.logo);
        this.root.attachChild(this.simsilica);
        this.root.setLocalTranslation(0.0f, 0.0f, -30.0f);
        this.block = new Panel();
        this.block.setBackground(new QuadBackgroundComponent(new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f)));
        Camera cam = app.getCamera();
        this.block.setPreferredSize(new Vector3f(cam.getWidth(), cam.getHeight(), 0.0f));
        this.block.setLocalTranslation(0.0f, cam.getHeight(), 0.0f);
        this.presented = new Label("Presented By:");
        this.presented.setFontSize(60.0f);
        pref = this.presented.getPreferredSize();
        this.presented.setLocalTranslation((float)cam.getWidth() * 0.5f - pref.x * 0.5f, (float)cam.getHeight() * 0.8f, 10.0f);
    }

    @Override
    protected void cleanup(Application app) {
    }

    protected void startMainMenu() {
        System.out.println("*********** start main menu ***********");
        this.getStateManager().attach(new MainMenuState());
        this.getStateManager().detach(this);
    }

    @Override
    protected void onEnable() {
        System.out.println("**** Intro onEnable()");
        this.getApplication().getInputManager().addRawInputListener(this.interruptListener);
        Node rootNode = ((Main)this.getApplication()).getRootNode();
        rootNode.attachChild(this.root);
        Node guiNode = ((Main)this.getApplication()).getGuiNode();
        guiNode.attachChild(this.block);
        guiNode.attachChild(this.presented);
        this.getState(SoundState.class).playMusic("Sounds/Space-Prelude.ogg");
        Tween fadeIn1 = Tweens.smoothStep(PanelTweens.fade(this.presented, Float.valueOf(0.0f), Float.valueOf(1.0f), 2.0));
        Tween fadeOut1 = Tweens.smoothStep(PanelTweens.fade(this.presented, Float.valueOf(1.0f), Float.valueOf(0.0f), 2.0));
        Tween fadeIn2 = Tweens.smoothStep(PanelTweens.fade(this.block, Float.valueOf(1.0f), Float.valueOf(0.0f), 2.0));
        Tween fadeOut2 = Tweens.smoothStep(PanelTweens.fade(this.block, Float.valueOf(0.0f), Float.valueOf(1.0f), 2.0));
        Tween presentFade = Tweens.sequence(fadeIn1, fadeOut1);
        Tween logoFade = Tweens.sequence(Tweens.delay(1.5), fadeIn2, Tweens.delay(1.0), fadeOut2, SpatialTweens.detach(this.block), SpatialTweens.detach(this.root));
        Tween starFieldFade = Tweens.callTweenMethod(2.0, this.getState(StarFieldState.class), "setAlpha", new Object[0]);
        starFieldFade = Tweens.smoothStep(starFieldFade);
        this.introAnim = this.anim.add(Tweens.parallel(logoFade, presentFade), starFieldFade, Tweens.callMethod(this, "startMainMenu", new Object[0]));
    }

    @Override
    public void update(float tpf) {
        Quaternion rot = new Quaternion().fromAngles(0.0f, tpf * 2.0f, 0.0f);
        this.logo.setLocalRotation(rot.mult(this.logo.getLocalRotation()));
    }

    @Override
    protected void onDisable() {
        System.out.println("**** Intro onDisable()");
        this.getApplication().getInputManager().removeRawInputListener(this.interruptListener);
        this.root.removeFromParent();
        this.block.removeFromParent();
    }

    private void interruptIntro() {
        if (this.interrupting) {
            return;
        }
        this.interrupting = true;
        System.out.println("Interrupt early!");
        System.out.println("Remaining:" + this.introAnim.getRemaining());
        if (this.introAnim.getRemaining() <= 0.0) {
            return;
        }
        System.out.println("Cancelling intro animation.");
        this.anim.cancel(this.introAnim);
        System.out.println("Creating a quick fade out animation.");
        Tween fadeOut1 = Tweens.smoothStep(PanelTweens.fade(this.presented, null, Float.valueOf(0.0f), 0.5));
        Tween fadeOut2 = Tweens.smoothStep(PanelTweens.fade(this.block, null, Float.valueOf(1.0f), 0.5));
        Tween fadeOut = Tweens.parallel(fadeOut1, fadeOut2);
        Tween starFieldFade = Tweens.callTweenMethod(0.5, this.getState(StarFieldState.class), "setAlpha", new Object[0]);
        starFieldFade = Tweens.smoothStep(starFieldFade);
        Tween fadeOut3 = Tweens.smoothStep(PanelTweens.fade(this.block, Float.valueOf(1.0f), Float.valueOf(0.0f), 0.5));
        Tween logoFadeOut = Tweens.sequence(fadeOut, SpatialTweens.detach(this.root));
        Tween blockFadeOut = Tweens.sequence(fadeOut3, SpatialTweens.detach(this.block));
        this.anim.add(logoFadeOut, Tweens.parallel(starFieldFade, blockFadeOut), Tweens.callMethod(this, "startMainMenu", new Object[0]));
    }

    private class InterruptListener
    extends DefaultRawInputListener {
        private InterruptListener() {
        }

        @Override
        public void onJoyButtonEvent(JoyButtonEvent evt) {
            IntroductionState.this.interruptIntro();
        }

        @Override
        public void onMouseButtonEvent(MouseButtonEvent evt) {
            IntroductionState.this.interruptIntro();
        }

        @Override
        public void onKeyEvent(KeyInputEvent evt) {
            IntroductionState.this.interruptIntro();
        }

        @Override
        public void onTouchEvent(TouchEvent evt) {
            IntroductionState.this.interruptIntro();
        }
    }
}

