/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks;

import com.jme3.app.Application;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.Vector2f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.EntitySet;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.event.BaseAppState;
import com.simsilica.mattacks.EntityDataState;
import com.simsilica.mattacks.Main;
import com.simsilica.mattacks.es.ModelType;
import com.simsilica.mattacks.es.Position;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ModelState.class);
    private EntityData ed;
    private EntitySet models;
    private Node root;
    private Map<ModelType, Spatial> templates = new HashMap<ModelType, Spatial>();
    private Map<EntityId, Spatial> modelCache = new HashMap<EntityId, Spatial>();

    public Node getModel(EntityId id) {
        return (Node)this.modelCache.get(id);
    }

    @Override
    protected void initialize(Application app) {
        this.ed = this.getState(EntityDataState.class).getEntityData();
        this.root = new Node("gameField");
        ((Main)app).getGuiNode().attachChild(this.root);
    }

    @Override
    protected void cleanup(Application app) {
    }

    @Override
    protected void enable() {
        this.models = this.ed.getEntities(Position.class, ModelType.class);
        this.models.applyChanges();
        this.addModels(this.models);
    }

    protected Spatial createTemplate(ModelType type) {
        GuiGlobals globals = GuiGlobals.getInstance();
        String s = type.getType(this.ed);
        Texture tex = globals.loadTexture("Textures/" + s + ".png", false, false);
        tex.setWrap(Texture.WrapAxis.T, Texture.WrapMode.Repeat);
        Material mat = globals.createMaterial(tex, false).getMaterial();
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        float width = tex.getImage().getWidth();
        float height = tex.getImage().getHeight();
        float scale = 100.0f / width;
        Quad quad = new Quad(width * scale, height * scale);
        quad.scaleTextureCoordinates(new Vector2f(1.0f, 1.0f));
        Geometry geom = new Geometry(s, quad);
        geom.setMaterial(mat);
        geom.center();
        Node result = new Node(s);
        result.attachChild(geom);
        return result;
    }

    protected Spatial getTemplate(ModelType type, boolean create) {
        Spatial result = this.templates.get(type);
        if (result == null && create) {
            result = this.createTemplate(type);
            this.templates.put(type, result);
        }
        return result;
    }

    protected Spatial createModel(Entity e, ModelType type) {
        Spatial result = this.modelCache.get(e.getId());
        if (result != null) {
            return result;
        }
        result = this.getTemplate(type, true).clone();
        this.updateModel(e, result);
        this.modelCache.put(e.getId(), result);
        return result;
    }

    protected void updateModel(Entity e, Spatial model) {
        Position pos = e.get(Position.class);
        if (pos == null) {
            return;
        }
        model.setLocalTranslation(pos.getLocation());
        model.setLocalRotation(pos.getFacing());
    }

    protected void addModels(Set<Entity> set) {
        for (Entity e : set) {
            ModelType type = e.get(ModelType.class);
            Spatial s = this.createModel(e, type);
            this.root.attachChild(s);
        }
    }

    protected void updateModels(Set<Entity> set) {
        for (Entity e : set) {
            Spatial model = this.modelCache.get(e.getId());
            if (model == null) continue;
            this.updateModel(e, model);
        }
    }

    protected void removeModels(Set<Entity> set) {
        for (Entity e : set) {
            Spatial model = this.modelCache.remove(e.getId());
            if (model == null) continue;
            model.removeFromParent();
        }
    }

    @Override
    public void update(float tpf) {
        if (this.models.applyChanges()) {
            this.removeModels(this.models.getRemovedEntities());
            this.addModels(this.models.getAddedEntities());
            this.updateModels(this.models.getChangedEntities());
        }
    }

    @Override
    protected void disable() {
        this.models.release();
        this.modelCache.clear();
    }
}

