/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.Command;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.component.IconComponent;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mattacks.Main;
import com.simsilica.mattacks.SoundCommand;

public class NumberPadState
extends BaseAppState {
    private Container window;
    private Label entry;
    private ActionButton clear;
    private ActionButton send;
    private Container numberPad;
    private SoundCommand openSound;
    private Command<Integer> submit;

    public NumberPadState() {
        this.setEnabled(false);
    }

    @Override
    protected void initialize(Application app) {
        this.window = new Container((GuiLayout)new BorderLayout(), new ElementId("window.container"));
        Container top = this.window.addChild(new Container(new BorderLayout()), new Object[]{BorderLayout.Position.North});
        this.entry = top.addChild(new Label(""), new Object[]{BorderLayout.Position.Center});
        this.clear = top.addChild(new ActionButton(new BackspaceAction()), new Object[]{BorderLayout.Position.East});
        this.clear.setTextHAlignment(HAlignment.Center);
        SoundCommand beep2 = SoundCommand.create(app.getAssetManager(), "Sounds/twoTone1.ogg", true);
        this.setup(this.clear, beep2);
        Container side = this.window.addChild(new Container(), new Object[]{BorderLayout.Position.East});
        this.send = side.addChild(new ActionButton(new SendAction()), new Object[0]);
        this.send.setTextHAlignment(HAlignment.Center);
        this.numberPad = this.window.addChild(new Container(new ElementId("numberpad.container")), new Object[]{BorderLayout.Position.Center});
        SoundCommand beep1 = SoundCommand.create(app.getAssetManager(), "Sounds/tone1.ogg", true);
        this.setup(this.numberPad.addChild(new ActionButton(new NumberAction(1)), 0, 0), beep1);
        this.setup(this.numberPad.addChild(new ActionButton(new NumberAction(2)), 0, 1), beep1);
        this.setup(this.numberPad.addChild(new ActionButton(new NumberAction(3)), 0, 2), beep1);
        this.setup(this.numberPad.addChild(new ActionButton(new NumberAction(4)), 1, 0), beep1);
        this.setup(this.numberPad.addChild(new ActionButton(new NumberAction(5)), 1, 1), beep1);
        this.setup(this.numberPad.addChild(new ActionButton(new NumberAction(6)), 1, 2), beep1);
        this.setup(this.numberPad.addChild(new ActionButton(new NumberAction(7)), 2, 0), beep1);
        this.setup(this.numberPad.addChild(new ActionButton(new NumberAction(8)), 2, 1), beep1);
        this.setup(this.numberPad.addChild(new ActionButton(new NumberAction(9)), 2, 2), beep1);
        this.setup(this.numberPad.addChild(new ActionButton(new NumberAction(0)), 3, 1), beep1);
        this.window.setLocalTranslation(0.0f, 700.0f, 0.0f);
        this.openSound = SoundCommand.create(app.getAssetManager(), "Sounds/pepSound5.ogg", true);
    }

    protected void setup(Button b, Command<Button> ... cmds) {
        for (Command<? super Button> cmd : b.getClickCommands()) {
            if (!(cmd instanceof SoundCommand)) continue;
            b.removeClickCommands(cmd);
        }
        b.addClickCommands(cmds);
    }

    public void activateNumberPad(float x, float y, Command<Integer> submit) {
        System.out.println("activateNumberPad(" + x + ", " + y + ")");
        this.submit = submit;
        this.setEnabled(true);
        Vector3f size = this.window.getSize();
        int width = this.getApplication().getCamera().getWidth();
        int height = this.getApplication().getCamera().getHeight();
        if (y > (float)height) {
            y = height;
        }
        System.out.println("y:" + y + " size.y:" + size.y + "  y-size.y:" + (y - size.y));
        if (y - size.y < 0.0f) {
            y = size.y;
        }
        if (x + size.x > (float)width) {
            x = (float)width - size.x;
        }
        this.window.setLocalTranslation(x, y, 10.0f);
        this.openSound.execute(this.send);
    }

    @Override
    protected void cleanup(Application app) {
    }

    @Override
    protected void onEnable() {
        ((Main)this.getApplication()).getGuiNode().attachChild(this.window);
    }

    @Override
    protected void onDisable() {
        this.window.removeFromParent();
    }

    private class NumberAction
    extends Action {
        private int number;

        public NumberAction(int number) {
            super(String.valueOf(number));
            this.number = number;
        }

        @Override
        public void execute(Button source) {
            System.out.println("#" + this.number);
            String s = NumberPadState.this.entry.getText();
            if (s.length() < 3) {
                NumberPadState.this.entry.setText(s + this.number);
            }
        }
    }

    private class BackspaceAction
    extends Action {
        public BackspaceAction() {
            super("");
            IconComponent icon = new IconComponent("Interface/backspace.png");
            icon.setIconScale(0.5f);
            icon.setColor(new ColorRGBA(0.1f, 0.6f, 0.7f, 0.7f));
            this.setIcon(icon);
        }

        @Override
        public void execute(Button source) {
            String s = NumberPadState.this.entry.getText();
            if (s.length() > 0) {
                s = s.substring(0, s.length() - 1);
                NumberPadState.this.entry.setText(s);
            }
        }
    }

    private class SendAction
    extends Action {
        public SendAction() {
            super("S\ne\nn\nd");
        }

        @Override
        public void execute(Button source) {
            String s = NumberPadState.this.entry.getText().trim();
            if (s.length() == 0) {
                return;
            }
            System.out.println("SEND:" + NumberPadState.this.entry.getText());
            NumberPadState.this.entry.setText("");
            NumberPadState.this.setEnabled(false);
            if (NumberPadState.this.submit != null) {
                int value = Integer.parseInt(s);
                NumberPadState.this.submit.execute(value);
            }
        }
    }
}

