/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks.achievement;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import com.simsilica.mattacks.Level;
import com.simsilica.mattacks.achievement.Achievement;
import com.simsilica.mattacks.achievement.AchievementRule;
import com.simsilica.mattacks.achievement.AchievementRules;
import com.simsilica.mattacks.achievement.AchievementType;
import com.simsilica.mattacks.achievement.AchievementUtils;
import com.simsilica.mattacks.achievement.Achievements;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class AchievementContext
extends HashMap<String, Object> {
    private final AchievementRules rules = new AchievementRules();
    private final Achievements set = new Achievements();

    public void setup() {
        this.put("levelAchievements", this.getLevelAchievements());
        this.put("categoryAchievements", this.getCategoryAchievements());
        this.put("dayAchievements", this.getDayAchievements());
        this.put("weekAchievements", this.getWeekAchievements());
        this.put("monthAchievements", this.getMonthAchievements());
    }

    public String getToday() {
        Calendar cal = Calendar.getInstance();
        int week = cal.get(3);
        int day = cal.get(7);
        return week + ":" + day;
    }

    public String getThisWeek() {
        Calendar cal = Calendar.getInstance();
        int week = cal.get(3);
        return String.valueOf(week);
    }

    public <T> T get(String key) {
        return (T)super.get(key);
    }

    public Collection<Achievement> getLevelAchievements() {
        Level level = (Level)this.get("level");
        if (level == null) {
            return Collections.emptySet();
        }
        LevelFilter pred = new LevelFilter(level, this.getToday());
        return Sets.filter(this.set, pred);
    }

    public Collection<Achievement> getCategoryAchievements() {
        String cat = (String)this.get("category");
        if (cat == null) {
            return Collections.emptySet();
        }
        CategoryFilter pred = new CategoryFilter(cat, this.getToday());
        return Sets.filter(this.set, pred);
    }

    public Collection<Achievement> getDayAchievements() {
        String day = (String)this.get("day");
        if (day == null) {
            return Collections.emptySet();
        }
        DayFilter pred = new DayFilter(day);
        return Sets.filter(this.set, pred);
    }

    public Collection<Achievement> getWeekAchievements() {
        String s = (String)this.get("week");
        if (s == null) {
            return Collections.emptySet();
        }
        WeekFilter pred = new WeekFilter(s);
        return Sets.filter(this.set, pred);
    }

    public Collection<Achievement> getMonthAchievements() {
        String s = (String)this.get("month");
        if (s == null) {
            return Collections.emptySet();
        }
        MonthFilter pred = new MonthFilter(s);
        return Sets.filter(this.set, pred);
    }

    public Collection<Achievement> getBestAchievements() {
        return AchievementUtils.best(this.set);
    }

    public boolean evaluateRules(AchievementType type) {
        return this.evaluateRules(type, null);
    }

    public boolean evaluateRules(AchievementType type, List<Achievement> added) {
        boolean result = false;
        for (AchievementRule rule : this.rules.getRules(type)) {
            Achievement a;
            if (!rule.getRule().apply(this) || !this.set.add(a = rule.getFactory().apply(this))) continue;
            System.out.println("New achievement:" + a);
            result = true;
            if (added == null) continue;
            added.add(a);
        }
        return result;
    }

    public boolean evaluateOtherRules(AchievementType skip) {
        return this.evaluateOtherRules(skip, null);
    }

    public boolean evaluateOtherRules(AchievementType skip, List<Achievement> added) {
        boolean result = false;
        for (AchievementRule rule : this.rules) {
            Achievement a;
            if (rule.getType() == skip || !rule.getRule().apply(this) || !this.set.add(a = rule.getFactory().apply(this))) continue;
            System.out.println("New achievement:" + a);
            result = true;
            if (added == null) continue;
            added.add(a);
        }
        return result;
    }

    public AchievementRules getRules() {
        return this.rules;
    }

    public Achievements getAchievements() {
        return this.set;
    }

    private static class MonthFilter
    implements Predicate<Achievement> {
        private final String name;

        public MonthFilter(String name) {
            this.name = name;
        }

        @Override
        public boolean apply(Achievement a) {
            return Objects.equals(a.month, this.name);
        }
    }

    private static class WeekFilter
    implements Predicate<Achievement> {
        private final String name;

        public WeekFilter(String name) {
            this.name = name;
        }

        @Override
        public boolean apply(Achievement a) {
            return Objects.equals(a.week, this.name);
        }
    }

    private static class DayFilter
    implements Predicate<Achievement> {
        private final String name;

        public DayFilter(String name) {
            this.name = name;
        }

        @Override
        public boolean apply(Achievement a) {
            return Objects.equals(a.day, this.name);
        }
    }

    private static class CategoryFilter
    implements Predicate<Achievement> {
        private final String name;
        private final String day;

        public CategoryFilter(String name, String day) {
            this.name = name;
            this.day = day;
        }

        @Override
        public boolean apply(Achievement a) {
            return Objects.equals(a.category, this.name) && Objects.equals(a.day, this.day);
        }
    }

    private static class LevelFilter
    implements Predicate<Achievement> {
        private final String name;
        private final String day;

        public LevelFilter(Level l, String day) {
            this.name = l.getName();
            this.day = day;
        }

        @Override
        public boolean apply(Achievement a) {
            return Objects.equals(a.level, this.name) && Objects.equals(a.day, this.day);
        }
    }
}

