/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks.db;

import com.simsilica.mattacks.achievement.Achievement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DbUtils {
    public static Map<String, Object> toMap(Achievement a) {
        Field[] fields;
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Field f : fields = Achievement.class.getFields()) {
            try {
                Object o = f.get(a);
                if (o == null) continue;
                result.put(f.getName(), o);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new RuntimeException("Error getting field:" + f, ex);
            }
        }
        return result;
    }

    public static Collection<Map<String, Object>> toMap(Collection<Achievement> achievements) {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        for (Achievement a : achievements) {
            results.add(DbUtils.toMap(a));
        }
        return results;
    }

    public static Achievement achievementFromMap(Map<String, Object> convert) {
        Field[] fields;
        Achievement result = new Achievement();
        for (Field f : fields = Achievement.class.getFields()) {
            Object o = convert.get(f.getName());
            if (o == null) continue;
            try {
                if (f.getType().isEnum()) {
                    Class<?> type = f.getType();
                    o = Enum.valueOf(type, String.valueOf(o));
                }
                f.set(result, o);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new RuntimeException("Error setting field:" + f + " to:" + o, ex);
            }
        }
        return result;
    }

    public static Collection<Achievement> achievementsFromMap(Collection<Map<String, Object>> convert) {
        ArrayList<Achievement> results = new ArrayList<Achievement>();
        for (Map<String, Object> m : convert) {
            results.add(DbUtils.achievementFromMap(m));
        }
        return results;
    }
}

