/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks.db;

import com.simsilica.mattacks.db.Player;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class PlayerDatabase {
    private final File root;
    private final Map<String, Player> playerIndex = new TreeMap<String, Player>();

    public PlayerDatabase(File root) {
        this.root = root;
        if (!root.exists()) {
            root.mkdirs();
        }
    }

    public static PlayerDatabase createDefault() {
        String home = System.getProperty("user.home");
        System.out.println("home:" + home);
        File f = new File(home);
        return new PlayerDatabase(new File(f, ".mattack"));
    }

    public List<Player> getPlayers() {
        return new ArrayList<Player>(this.playerIndex.values());
    }

    public Player getPlayer(String name) {
        return this.playerIndex.get(name);
    }

    public Player createPlayer(String name) {
        if (this.playerIndex.containsKey(name)) {
            return null;
        }
        File f = new File(this.root, name + ".player");
        Player result = new Player(f, name);
        result.save();
        this.playerIndex.put(result.getName(), result);
        return result;
    }

    public static void main(String ... args) {
        PlayerDatabase db = PlayerDatabase.createDefault();
        db.initialize();
    }

    public void initialize() {
        for (File f : this.root.listFiles()) {
            System.out.println("Checking:" + f);
            if (!f.getName().endsWith(".player")) continue;
            System.out.println("Player file:" + f);
            Player p = new Player(f);
            this.playerIndex.put(p.getName(), p);
        }
    }
}

