/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks.es;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.simsilica.es.EntityComponent;

public class Position
implements EntityComponent {
    private Vector3f location;
    private Quaternion facing;

    public Position() {
        this(0.0f, 0.0f);
    }

    public Position(float x, float y) {
        this(new Vector3f(x, y, 0.0f), new Quaternion());
    }

    public Position(float x, float y, float z) {
        this(new Vector3f(x, y, z), new Quaternion());
    }

    public Position(Vector3f loc) {
        this(loc, new Quaternion());
    }

    public Position(Vector3f loc, Quaternion quat) {
        this.location = loc;
        this.facing = quat;
    }

    public Position changeLocation(Vector3f location) {
        return new Position(location, this.facing);
    }

    public Position changeFacing(Quaternion facing) {
        return new Position(this.location, facing);
    }

    public Position integrate(Vector3f v, double t) {
        double x = (double)this.location.x + (double)v.x * t;
        double y = (double)this.location.y + (double)v.y * t;
        double z = (double)this.location.z + (double)v.z * t;
        return new Position(new Vector3f((float)x, (float)y, (float)z));
    }

    public Vector3f getLocation() {
        return this.location;
    }

    public Quaternion getFacing() {
        return this.facing;
    }

    public String toString() {
        return "Position[location=" + this.location + ", facing=" + this.facing + "]";
    }
}

