/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks.util;

import com.simsilica.es.Entity;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.EntitySet;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntityContainer<T> {
    static Logger log = LoggerFactory.getLogger(EntityContainer.class);
    private EntityData ed;
    private Class<? extends EntityComponent>[] componentTypes;
    private EntitySet entities;
    private T[] array;
    private Map<EntityId, T> objects = new HashMap<EntityId, T>();
    private Class parameter;

    protected EntityContainer(EntityData ed, Class<? extends EntityComponent> ... componentTypes) {
        this.ed = ed;
        this.componentTypes = componentTypes;
        Type t = this.getClass().getGenericSuperclass();
        while (t != null) {
            if (t instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)t;
                if (pt.getRawType() != EntityContainer.class) continue;
                this.parameter = (Class)pt.getActualTypeArguments()[0];
                break;
            }
            if (t instanceof Class) {
                t = ((Class)t).getGenericSuperclass();
                continue;
            }
            t = null;
        }
    }

    protected void addComponentTypes(Class<? extends EntityComponent> ... add) {
        Class[] merged = new Class[add.length + this.componentTypes.length];
        System.arraycopy(this.componentTypes, 0, merged, 0, this.componentTypes.length);
        System.arraycopy(add, 0, merged, this.componentTypes.length, add.length);
        this.componentTypes = merged;
    }

    public int size() {
        return this.entities.size();
    }

    public T getObject(EntityId id) {
        return this.objects.get(id);
    }

    protected T[] getArray() {
        if (this.array != null) {
            return this.array;
        }
        this.array = (Object[])Array.newInstance(this.parameter, this.objects.size());
        this.array = this.objects.values().toArray(this.array);
        return this.array;
    }

    protected abstract T addObject(Entity var1);

    protected abstract void updateObject(T var1, Entity var2);

    protected abstract void removeObject(T var1, Entity var2);

    protected void addObjects(Set<Entity> set) {
        if (set.isEmpty()) {
            return;
        }
        for (Entity e : set) {
            T object = this.addObject(e);
            this.objects.put(e.getId(), object);
        }
        this.array = null;
    }

    protected void updateObjects(Set<Entity> set) {
        if (set.isEmpty()) {
            return;
        }
        for (Entity e : set) {
            T object = this.objects.get(e.getId());
            if (object == null) {
                log.warn("Update: No matching object for entity:" + e);
                continue;
            }
            this.updateObject(object, e);
        }
    }

    protected void removeObjects(Set<Entity> set) {
        if (set.isEmpty()) {
            return;
        }
        for (Entity e : set) {
            T object = this.objects.remove(e.getId());
            if (object == null) {
                log.warn("Remove: No matching object for entity:" + e);
                continue;
            }
            this.removeObject(object, e);
        }
        this.array = null;
    }

    public void start() {
        this.entities = this.ed.getEntities(this.componentTypes);
        this.entities.applyChanges();
        this.addObjects(this.entities);
    }

    public boolean update() {
        if (this.entities.applyChanges()) {
            this.removeObjects(this.entities.getRemovedEntities());
            this.addObjects(this.entities.getAddedEntities());
            this.updateObjects(this.entities.getChangedEntities());
            return true;
        }
        return false;
    }

    public void stop() {
        this.removeObjects(this.entities);
        this.entities.release();
    }

    public String toString() {
        return this.getClass().getName() + "[components=" + Arrays.asList(this.componentTypes) + "]";
    }
}

