/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx.file;

import com.jme3.scene.plugins.fbx.file.FbxElement;
import com.jme3.scene.plugins.fbx.file.FbxFile;
import com.jme3.scene.plugins.fbx.file.FbxId;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FbxDump {
    private static final Logger logger = Logger.getLogger(FbxDump.class.getName());
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.0000000000");

    private FbxDump() {
    }

    private static Map<FbxId, FbxElement> createUidToObjectMap(FbxFile file) {
        HashMap<FbxId, FbxElement> uidToObjectMap = new HashMap<FbxId, FbxElement>();
        for (FbxElement rootElement : file.rootElements) {
            if (!rootElement.id.equals("Objects")) continue;
            for (FbxElement fbxObj : rootElement.children) {
                FbxId uid = FbxId.getObjectId(fbxObj);
                if (uid != null) {
                    uidToObjectMap.put(uid, fbxObj);
                    continue;
                }
                logger.log(Level.WARNING, "Cannot determine ID for object: {0}", fbxObj);
            }
        }
        return uidToObjectMap;
    }

    public static void dumpFile(FbxFile file) {
        FbxDump.dumpFile(file, System.out);
    }

    public static void dumpFile(FbxFile file, OutputStream out) {
        Map<FbxId, FbxElement> uidToObjectMap = FbxDump.createUidToObjectMap(file);
        PrintStream ps = new PrintStream(out);
        for (FbxElement rootElement : file.rootElements) {
            FbxDump.dumpElement(rootElement, ps, 0, uidToObjectMap);
        }
    }

    private static String indent(int amount) {
        return "                        ".substring(0, amount);
    }

    private static String convertFBXString(String string) {
        return string.replaceAll("\u0000\u0001", "::");
    }

    protected static void dumpProperty(String id, char propertyType, Object property, PrintStream ps, Map<FbxId, FbxElement> uidToObjectMap) {
        switch (propertyType) {
            case 'S': {
                String str = (String)property;
                ps.print("\"" + FbxDump.convertFBXString(str) + "\"");
                break;
            }
            case 'R': {
                byte[] bytes = (byte[])property;
                int numToPrint = Math.min(10240, bytes.length);
                ps.print("(size = ");
                ps.print(bytes.length);
                ps.print(") [");
                for (int j = 0; j < numToPrint; ++j) {
                    ps.print(String.format("%02X", bytes[j] & 0xFF));
                    if (j == bytes.length - 1) continue;
                    ps.print(" ");
                }
                if (numToPrint < bytes.length) {
                    ps.print(" ...");
                }
                ps.print("]");
                break;
            }
            case 'D': 
            case 'F': {
                if (property instanceof Double) {
                    ps.print(DECIMAL_FORMAT.format((Double)property));
                    break;
                }
                if (property instanceof Float) {
                    ps.print(DECIMAL_FORMAT.format((Float)property));
                    break;
                }
                ps.print(property);
                break;
            }
            case 'I': 
            case 'Y': {
                ps.print(property);
                break;
            }
            case 'C': {
                ps.print((Boolean)property != false ? "1" : "0");
                break;
            }
            case 'L': {
                if (id.equals("C")) {
                    Long uid = (Long)property;
                    FbxElement element = uidToObjectMap.get(FbxId.create(uid));
                    if (element != null) {
                        String name = (String)element.properties.get(1);
                        ps.print("\"" + FbxDump.convertFBXString(name) + "\"");
                        break;
                    }
                    ps.print(property);
                    break;
                }
                ps.print(property);
                break;
            }
            case 'd': 
            case 'f': 
            case 'i': 
            case 'l': {
                int length = Array.getLength(property);
                for (int j = 0; j < length; ++j) {
                    Object arrayEntry = Array.get(property, j);
                    FbxDump.dumpProperty(id, Character.toUpperCase(propertyType), arrayEntry, ps, uidToObjectMap);
                    if (j == length - 1) continue;
                    ps.print(",");
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("" + propertyType);
            }
        }
    }

    protected static void dumpElement(FbxElement el, PrintStream ps, int indent, Map<FbxId, FbxElement> uidToObjectMap) {
        String indentStr = FbxDump.indent(indent * 4);
        String textId = el.id;
        ps.print(indentStr + textId + ": ");
        for (int i = 0; i < el.properties.size(); ++i) {
            Object property = el.properties.get(i);
            char propertyType = el.propertiesTypes[i];
            FbxDump.dumpProperty(el.id, propertyType, property, ps, uidToObjectMap);
            if (i == el.properties.size() - 1) continue;
            ps.print(", ");
        }
        if (el.children.isEmpty()) {
            ps.println();
        } else {
            ps.println(" {");
            for (FbxElement childElement : el.children) {
                FbxDump.dumpElement(childElement, ps, indent + 1, uidToObjectMap);
            }
            ps.println(indentStr + "}");
        }
    }
}

