/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx.node;

import com.jme3.animation.AnimControl;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SkeletonControl;
import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.debug.SkeletonDebugger;
import com.jme3.scene.plugins.fbx.anim.FbxAnimCurveNode;
import com.jme3.scene.plugins.fbx.anim.FbxCluster;
import com.jme3.scene.plugins.fbx.anim.FbxLimbNode;
import com.jme3.scene.plugins.fbx.anim.FbxSkinDeformer;
import com.jme3.scene.plugins.fbx.file.FbxElement;
import com.jme3.scene.plugins.fbx.material.FbxImage;
import com.jme3.scene.plugins.fbx.material.FbxMaterial;
import com.jme3.scene.plugins.fbx.material.FbxTexture;
import com.jme3.scene.plugins.fbx.mesh.FbxMesh;
import com.jme3.scene.plugins.fbx.node.FbxNodeAttribute;
import com.jme3.scene.plugins.fbx.node.FbxNodeUtil;
import com.jme3.scene.plugins.fbx.node.FbxNullAttribute;
import com.jme3.scene.plugins.fbx.obj.FbxObject;
import com.jme3.util.IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FbxNode
extends FbxObject<Spatial> {
    private static final Logger logger = Logger.getLogger(FbxNode.class.getName());
    private InheritMode inheritMode = InheritMode.ScaleAfterChildRotation;
    protected FbxNode parent;
    protected List<FbxNode> children = new ArrayList<FbxNode>();
    protected List<FbxMaterial> materials = new ArrayList<FbxMaterial>();
    protected Map<String, Object> userData = new HashMap<String, Object>();
    protected Map<String, List<FbxAnimCurveNode>> propertyToAnimCurveMap = new HashMap<String, List<FbxAnimCurveNode>>();
    protected FbxNodeAttribute nodeAttribute;
    protected double visibility = 1.0;
    protected Skeleton skeleton;
    protected final Transform jmeWorldNodeTransform = new Transform();
    protected final Transform jmeLocalNodeTransform = new Transform();
    protected Transform jmeWorldBindPose;
    protected Transform jmeLocalBindPose;
    protected Matrix4f cachedWorldBindPose;

    public FbxNode(AssetManager assetManager, String sceneFolderName) {
        super(assetManager, sceneFolderName);
    }

    public Transform computeFbxLocalTransform() {
        Matrix4f scaleMat = new Matrix4f();
        scaleMat.setScale(this.jmeLocalNodeTransform.getScale());
        Matrix4f rotationMat = new Matrix4f();
        rotationMat.setRotationQuaternion(this.jmeLocalNodeTransform.getRotation());
        Matrix4f translationMat = new Matrix4f();
        translationMat.setTranslation(this.jmeLocalNodeTransform.getTranslation());
        Matrix4f result = new Matrix4f();
        result.multLocal(scaleMat).multLocal(rotationMat).multLocal(translationMat);
        Transform t = new Transform();
        t.fromTransformMatrix(result);
        return t;
    }

    public void setWorldBindPose(Matrix4f worldBindPose) {
        if (this.cachedWorldBindPose != null && !this.cachedWorldBindPose.equals((Object)worldBindPose)) {
            throw new UnsupportedOperationException("Bind poses don't match");
        }
        this.cachedWorldBindPose = worldBindPose;
        this.jmeWorldBindPose = new Transform();
        this.jmeWorldBindPose.setTranslation(worldBindPose.toTranslationVector());
        this.jmeWorldBindPose.setRotation(worldBindPose.toRotationQuat());
        this.jmeWorldBindPose.setScale(worldBindPose.toScaleVector());
        System.out.println("\tBind Pose for " + this.getName());
        System.out.println(this.jmeWorldBindPose);
        float[] angles = new float[3];
        this.jmeWorldBindPose.getRotation().toAngles(angles);
        System.out.println("Angles: " + angles[0] * 57.295776f + ", " + angles[1] * 57.295776f + ", " + angles[2] * 57.295776f);
    }

    public void updateWorldTransforms(Transform jmeParentNodeTransform, Transform parentBindPose) {
        Transform fbxLocalTransform = this.computeFbxLocalTransform();
        this.jmeLocalNodeTransform.set(fbxLocalTransform);
        if (jmeParentNodeTransform != null) {
            jmeParentNodeTransform = jmeParentNodeTransform.clone();
            switch (this.inheritMode) {
                case NoParentScale: 
                case ScaleAfterChildRotation: 
                case ScaleBeforeChildRotation: {
                    this.jmeWorldNodeTransform.set(this.jmeLocalNodeTransform);
                    this.jmeWorldNodeTransform.combineWithParent(jmeParentNodeTransform);
                }
            }
        } else {
            this.jmeWorldNodeTransform.set(this.jmeLocalNodeTransform);
        }
        if (this.jmeWorldBindPose != null) {
            this.jmeLocalBindPose = new Transform();
            this.jmeLocalBindPose.set(this.jmeWorldBindPose);
            this.jmeLocalBindPose.combineWithParent(parentBindPose.invert());
            System.out.println("Bind Pose for: " + this.getName());
            if (!this.jmeLocalBindPose.equals(this.jmeLocalNodeTransform)) {
                System.out.println("Local Bind: " + this.jmeLocalBindPose);
                System.out.println("Local Trans: " + this.jmeLocalNodeTransform);
            }
            if (!this.jmeWorldBindPose.equals(this.jmeWorldNodeTransform)) {
                System.out.println("World Bind: " + this.jmeWorldBindPose);
                System.out.println("World Trans: " + this.jmeWorldNodeTransform);
            }
        } else {
            this.jmeLocalBindPose = new Transform();
            this.jmeWorldBindPose = new Transform();
            this.jmeLocalBindPose.set(this.jmeLocalNodeTransform);
            if (parentBindPose != null) {
                this.jmeWorldBindPose.set(this.jmeLocalNodeTransform);
                this.jmeWorldBindPose.combineWithParent(parentBindPose);
            } else {
                this.jmeWorldBindPose.set(this.jmeWorldNodeTransform);
            }
        }
        for (FbxNode child : this.children) {
            child.updateWorldTransforms(this.jmeWorldNodeTransform, this.jmeWorldBindPose);
        }
    }

    @Override
    public void fromElement(FbxElement element) {
        super.fromElement(element);
        Vector3f localTranslation = new Vector3f();
        Quaternion localRotation = new Quaternion();
        Vector3f localScale = new Vector3f(Vector3f.UNIT_XYZ);
        Quaternion preRotation = new Quaternion();
        for (FbxElement e2 : element.getFbxProperties()) {
            Object userDataValue;
            String propName = (String)e2.properties.get(0);
            String type = (String)e2.properties.get(3);
            if (propName.equals("Lcl Translation")) {
                double x = (Double)e2.properties.get(4);
                double y = (Double)e2.properties.get(5);
                double z = (Double)e2.properties.get(6);
                localTranslation.set((float)x, (float)y, (float)z);
                continue;
            }
            if (propName.equals("Lcl Rotation")) {
                double x = (Double)e2.properties.get(4);
                double y = (Double)e2.properties.get(5);
                double z = (Double)e2.properties.get(6);
                localRotation.fromAngles((float)x * ((float)Math.PI / 180), (float)y * ((float)Math.PI / 180), (float)z * ((float)Math.PI / 180));
                continue;
            }
            if (propName.equals("Lcl Scaling")) {
                double x = (Double)e2.properties.get(4);
                double y = (Double)e2.properties.get(5);
                double z = (Double)e2.properties.get(6);
                localScale.set((float)x, (float)y, (float)z);
                continue;
            }
            if (propName.equals("PreRotation")) {
                double x = (Double)e2.properties.get(4);
                double y = (Double)e2.properties.get(5);
                double z = (Double)e2.properties.get(6);
                preRotation.set(FbxNodeUtil.quatFromBoneAngles((float)x * ((float)Math.PI / 180), (float)y * ((float)Math.PI / 180), (float)z * ((float)Math.PI / 180)));
                continue;
            }
            if (propName.equals("InheritType")) {
                int inheritType = (Integer)e2.properties.get(4);
                this.inheritMode = InheritMode.values()[inheritType];
                continue;
            }
            if (propName.equals("Visibility")) {
                this.visibility = (Double)e2.properties.get(4);
                continue;
            }
            if (!type.contains("U")) continue;
            String userDataKey = (String)e2.properties.get(0);
            String userDataType = (String)e2.properties.get(1);
            if (userDataType.equals("KString")) {
                userDataValue = (String)e2.properties.get(4);
            } else if (userDataType.equals("int")) {
                userDataValue = (Integer)e2.properties.get(4);
            } else if (userDataType.equals("double")) {
                userDataValue = Float.valueOf(((Double)e2.properties.get(4)).floatValue());
            } else if (userDataType.equals("Vector")) {
                float x = ((Double)e2.properties.get(4)).floatValue();
                float y = ((Double)e2.properties.get(5)).floatValue();
                float z = ((Double)e2.properties.get(6)).floatValue();
                userDataValue = new Vector3f(x, y, z);
            } else {
                logger.log(Level.WARNING, "Unsupported user data type: {0}. Ignoring.", userDataType);
                continue;
            }
            this.userData.put(userDataKey, userDataValue);
        }
        this.jmeLocalNodeTransform.setTranslation(localTranslation);
        this.jmeLocalNodeTransform.setRotation(localRotation);
        this.jmeLocalNodeTransform.setScale(localScale);
        if (element.getChildById("Vertices") != null) {
            FbxMesh mesh = new FbxMesh(this.assetManager, this.sceneFolderName);
            mesh.fromElement(element);
            this.connectObject(mesh);
        }
    }

    private Spatial tryCreateGeometry(int materialIndex, Mesh jmeMesh, boolean single) {
        Material jmeMat;
        if (materialIndex == -1) {
            materialIndex = 0;
        }
        if (materialIndex >= this.materials.size()) {
            jmeMat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
            jmeMat.setReceivesShadows(true);
        } else {
            FbxMaterial fbxMat = this.materials.get(materialIndex);
            jmeMat = (Material)fbxMat.getJmeObject();
        }
        String geomName = this.getName();
        geomName = single ? geomName + "-submesh" : geomName + "-mat-" + materialIndex + "-submesh";
        Geometry spatial = new Geometry(geomName, jmeMesh);
        spatial.setMaterial(jmeMat);
        if (jmeMat.isTransparent()) {
            spatial.setQueueBucket(RenderQueue.Bucket.Transparent);
        }
        if (jmeMat.isReceivesShadows()) {
            spatial.setShadowMode(RenderQueue.ShadowMode.Receive);
        }
        spatial.updateModelBound();
        return spatial;
    }

    public FbxNode getPreferredParent() {
        if (!(this.nodeAttribute instanceof FbxMesh)) {
            return null;
        }
        FbxMesh fbxMesh = (FbxMesh)this.nodeAttribute;
        FbxSkinDeformer deformer = fbxMesh.getSkinDeformer();
        FbxNode preferredParent = null;
        if (deformer != null) {
            for (FbxCluster cluster : (List)deformer.getJmeObject()) {
                FbxLimbNode limb = cluster.getLimb();
                if (preferredParent == null) {
                    preferredParent = limb.getSkeletonHolder();
                    continue;
                }
                if (preferredParent == limb.getSkeletonHolder()) continue;
                logger.log(Level.WARNING, "A mesh is being deformed by multiple skeletons. Only one skeleton will work, ignoring other skeletons.");
            }
        }
        return preferredParent;
    }

    @Override
    public Spatial toJmeObject() {
        Node spatial;
        if (this.nodeAttribute instanceof FbxMesh) {
            FbxMesh fbxMesh = (FbxMesh)this.nodeAttribute;
            IntMap jmeMeshes = (IntMap)fbxMesh.getJmeObject();
            if (jmeMeshes == null || jmeMeshes.size() == 0) {
                logger.log(Level.WARNING, "No meshes could be loaded. Creating empty node.");
                spatial = new Node(this.getName() + "-node");
            } else {
                String nodeName = this.children.isEmpty() ? this.getName() + "-mesh" : this.getName() + "-node";
                Node node = new Node(nodeName);
                boolean singleMesh = jmeMeshes.size() == 1;
                for (IntMap.Entry meshInfo : jmeMeshes) {
                    node.attachChild(this.tryCreateGeometry(meshInfo.getKey(), (Mesh)meshInfo.getValue(), singleMesh));
                }
                spatial = node;
            }
        } else {
            if (this.nodeAttribute != null) {
                this.nodeAttribute.getJmeObject();
            }
            spatial = new Node(this.getName() + "-node");
        }
        if (!this.children.isEmpty()) {
            Vector3f localScale = this.jmeLocalNodeTransform.getScale();
            if (!FastMath.approximateEquals((float)localScale.x, (float)localScale.y) || !FastMath.approximateEquals((float)localScale.x, (float)localScale.z)) {
                logger.log(Level.WARNING, "Non-uniform scale detected on parent node. The model may appear distorted.");
            }
        }
        spatial.setLocalTransform(this.jmeLocalNodeTransform);
        if (this.visibility == 0.0) {
            spatial.setCullHint(Spatial.CullHint.Always);
        }
        for (Map.Entry<String, Object> userDataEntry : this.userData.entrySet()) {
            spatial.setUserData(userDataEntry.getKey(), userDataEntry.getValue());
        }
        return spatial;
    }

    public static void createSkeletons(FbxNode fbxNode) {
        boolean createSkeleton = false;
        for (FbxNode fbxChild : fbxNode.children) {
            if (fbxChild instanceof FbxLimbNode) {
                createSkeleton = true;
                continue;
            }
            FbxNode.createSkeletons(fbxChild);
        }
        if (createSkeleton) {
            if (fbxNode.skeleton != null) {
                throw new UnsupportedOperationException();
            }
            fbxNode.skeleton = FbxLimbNode.createSkeleton(fbxNode);
            System.out.println("created skeleton: " + fbxNode.skeleton);
        }
    }

    private static void relocateSpatial(Spatial spatial, Transform originalWorldTransform, Transform newWorldTransform) {
        Transform localTransform = new Transform();
        localTransform.set(originalWorldTransform);
        localTransform.combineWithParent(newWorldTransform.invert());
        spatial.setLocalTransform(localTransform);
    }

    public static Spatial createScene(FbxNode fbxNode) {
        Spatial jmeSpatial = (Spatial)fbxNode.getJmeObject();
        if (jmeSpatial instanceof Node) {
            Node jmeNode = (Node)jmeSpatial;
            for (FbxNode fbxChild : fbxNode.children) {
                if (fbxChild instanceof FbxLimbNode) continue;
                FbxNode.createScene(fbxChild);
                FbxNode preferredParent = fbxChild.getPreferredParent();
                Spatial jmeChild = (Spatial)fbxChild.getJmeObject();
                if (preferredParent != null) {
                    System.out.println("Preferred parent for " + fbxChild + " is " + preferredParent);
                    Node jmePreferredParent = (Node)preferredParent.getJmeObject();
                    FbxNode.relocateSpatial(jmeChild, fbxChild.jmeWorldNodeTransform, preferredParent.jmeWorldNodeTransform);
                    jmePreferredParent.attachChild(jmeChild);
                    continue;
                }
                jmeNode.attachChild(jmeChild);
            }
        }
        if (fbxNode.skeleton != null) {
            jmeSpatial.addControl((Control)new AnimControl(fbxNode.skeleton));
            jmeSpatial.addControl((Control)new SkeletonControl(fbxNode.skeleton));
            SkeletonDebugger sd = new SkeletonDebugger("debug", fbxNode.skeleton);
            Material mat = new Material(fbxNode.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
            mat.getAdditionalRenderState().setWireframe(true);
            mat.getAdditionalRenderState().setDepthTest(false);
            mat.setColor("Color", ColorRGBA.Green);
            sd.setMaterial(mat);
            ((Node)jmeSpatial).attachChild((Spatial)sd);
        }
        return jmeSpatial;
    }

    public Skeleton getJmeSkeleton() {
        return this.skeleton;
    }

    public List<FbxNode> getChildren() {
        return this.children;
    }

    @Override
    public void connectObject(FbxObject object) {
        if (object instanceof FbxNode) {
            FbxNode childNode = (FbxNode)object;
            if (childNode.parent != null) {
                throw new IllegalStateException("Cannot attach " + childNode + " to " + this + ". It is already " + "attached to " + childNode.parent);
            }
            childNode.parent = this;
            this.children.add(childNode);
        } else if (object instanceof FbxNodeAttribute) {
            if (this.nodeAttribute != null) {
                throw new IllegalStateException("An FBXNodeAttribute (" + this.nodeAttribute + ")" + " is already attached to " + this + ". " + "Only one attribute allowed per node.");
            }
            this.nodeAttribute = (FbxNodeAttribute)object;
            if (this.nodeAttribute instanceof FbxNullAttribute) {
                this.nodeAttribute.getJmeObject();
            }
        } else if (object instanceof FbxMaterial) {
            this.materials.add((FbxMaterial)object);
        } else if (!(object instanceof FbxImage) && !(object instanceof FbxTexture)) {
            this.unsupportedConnectObject(object);
        }
    }

    @Override
    public void connectObjectProperty(FbxObject object, String property) {
        if (object instanceof FbxAnimCurveNode) {
            FbxAnimCurveNode curveNode = (FbxAnimCurveNode)object;
            if (property.equals("Lcl Translation") || property.equals("Lcl Rotation") || property.equals("Lcl Scaling")) {
                List<FbxAnimCurveNode> curveNodes = this.propertyToAnimCurveMap.get(property);
                if (curveNodes == null) {
                    curveNodes = new ArrayList<FbxAnimCurveNode>();
                    curveNodes.add(curveNode);
                    this.propertyToAnimCurveMap.put(property, curveNodes);
                }
                curveNodes.add(curveNode);
                curveNode.addInfluencedNode(this, property);
            } else {
                logger.log(Level.WARNING, "Animating the property ''{0}'' is not supported. Ignoring.", property);
            }
        } else {
            this.unsupportedConnectObjectProperty(object, property);
        }
    }

    private static enum InheritMode {
        ScaleAfterChildRotation,
        ScaleBeforeChildRotation,
        NoParentScale;

    }
}

