/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.Command;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.EmptyAction;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.style.Styles;

public class OptionPanel
extends Panel {
    public static final String ELEMENT_ID = "optionPanel";
    public static final String EFFECT_OPEN = "open";
    public static final String EFFECT_CLOSE = "close";
    private BorderLayout layout;
    private Label titleLabel;
    private Label messageLabel;
    private Container buttons;
    private Container container;
    private Action[] options;
    private OptionListener listener = new OptionListener();

    public OptionPanel(String message, Action ... options) {
        this(true, null, message, options, new ElementId(ELEMENT_ID), null);
    }

    public OptionPanel(String title, String message, String style, Action ... options) {
        this(true, title, message, options, new ElementId(ELEMENT_ID), style);
    }

    public OptionPanel(String title, String message, ElementId elementId, String style, Action ... options) {
        this(true, title, message, options, elementId, style);
    }

    protected OptionPanel(boolean applyStyles, String title, String message, Action[] options, ElementId elementId, String style) {
        super(false, elementId, style);
        this.layout = new BorderLayout();
        ((GuiControl)this.getControl(GuiControl.class)).setLayout((GuiLayout)this.layout);
        if (title != null) {
            this.titleLabel = new Label(title, this.getElementId().child("title.label"), style);
            this.layout.addChild((Node)this.titleLabel, new Object[]{BorderLayout.Position.North});
        }
        this.container = new Container(this.getElementId().child("container"), style);
        this.layout.addChild((Node)this.container, new Object[]{BorderLayout.Position.Center});
        if (message != null) {
            this.messageLabel = new Label(message, this.getElementId().child("message.label"), style);
            this.container.addChild((Node)this.messageLabel, new Object[0]);
        }
        this.buttons = new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y, FillMode.ForcedEven, FillMode.Even), this.getElementId().child("buttons"), style);
        this.setOptions(options);
        this.layout.addChild((Node)this.buttons, new Object[]{BorderLayout.Position.South});
        if (applyStyles) {
            Styles styles = GuiGlobals.getInstance().getStyles();
            styles.applyStyles((Object)this, elementId, style);
        }
    }

    public void setTitle(String title) {
        if (this.titleLabel == null && title != null) {
            this.titleLabel = new Label(title, this.getElementId().child("title.label"), this.getStyle());
            this.layout.addChild((Node)this.titleLabel, new Object[]{BorderLayout.Position.North});
        } else if (this.titleLabel != null && title == null) {
            this.layout.removeChild((Node)this.titleLabel);
            this.titleLabel = null;
        } else {
            this.titleLabel.setText(title);
        }
    }

    public String getTitle() {
        return this.titleLabel == null ? null : this.titleLabel.getText();
    }

    public void setMessage(String message) {
        if (this.messageLabel == null && message != null) {
            this.messageLabel = new Label(message, this.getElementId().child("message.label"), this.getStyle());
            this.container.addChild((Node)this.messageLabel, new Object[0]);
        } else if (this.messageLabel != null && message == null) {
            this.layout.removeChild((Node)this.messageLabel);
            this.messageLabel = null;
        } else {
            this.messageLabel.setText(message);
        }
    }

    public String getMessage() {
        return this.messageLabel == null ? null : this.messageLabel.getText();
    }

    public void setOptions(Action ... options) {
        if (this.options == options) {
            return;
        }
        if (this.options != null) {
            for (Node n : this.buttons.getLayout().getChildren()) {
                if (!(n instanceof Button)) continue;
                ((Button)n).removeClickCommands(new Command[]{this.listener});
            }
        }
        this.options = options;
        this.buttons.clearChildren();
        if (options.length == 0) {
            options = new Action[]{new EmptyAction("Ok")};
        }
        for (Action a : options) {
            ActionButton button = new ActionButton(a, this.getElementId().child("button"), this.getStyle());
            button.addClickCommands(new Command[]{this.listener});
            this.buttons.addChild((Node)button, new Object[0]);
        }
    }

    public Action[] getOptions() {
        return this.options;
    }

    public Container getContainer() {
        return this.container;
    }

    public Label getTitleLabel() {
        return this.titleLabel;
    }

    public Label getMessageabel() {
        return this.messageLabel;
    }

    public Container getButtons() {
        return this.buttons;
    }

    public boolean isVisible() {
        if (this.getParent() == null) {
            return false;
        }
        return this.getCullHint() != Spatial.CullHint.Always;
    }

    public void close() {
        if (this.hasEffect(EFFECT_CLOSE)) {
            this.runEffect(EFFECT_CLOSE);
        } else if (this.getParent() instanceof Container) {
            ((Container)this.getParent()).removeChild((Node)this);
        } else {
            this.removeFromParent();
        }
    }

    private class OptionListener
    implements Command<Button> {
        private OptionListener() {
        }

        public void execute(Button source) {
            OptionPanel.this.close();
        }
    }
}

