/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.simsilica.lemur.Command;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.core.CommandMap;
import com.simsilica.lemur.event.DefaultMouseListener;
import com.simsilica.lemur.event.FocusMouseListener;
import com.simsilica.lemur.event.MouseEventControl;
import com.simsilica.lemur.style.Attributes;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.style.StyleAttribute;
import com.simsilica.lemur.style.StyleDefaults;
import com.simsilica.lemur.style.Styles;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class Button
extends Label {
    public static final String ELEMENT_ID = "button";
    public static final String EFFECT_PRESS = "press";
    public static final String EFFECT_RELEASE = "release";
    public static final String EFFECT_CLICK = "click";
    public static final String EFFECT_ACTIVATE = "activate";
    public static final String EFFECT_DEACTIVATE = "deactivate";
    private boolean enabled = true;
    private ColorRGBA color;
    private ColorRGBA shadowColor;
    private ColorRGBA highlightColor;
    private ColorRGBA highlightShadowColor;
    private boolean highlightOn;
    private boolean pressed;
    private CommandMap<Button, ButtonAction> commandMap = new CommandMap(this);

    public Button(String s) {
        this(s, true, new ElementId(ELEMENT_ID), null);
    }

    public Button(String s, String style) {
        this(s, true, new ElementId(ELEMENT_ID), style);
    }

    public Button(String s, ElementId elementId, String style) {
        this(s, true, elementId, style);
    }

    protected Button(String s, boolean applyStyles, ElementId elementId, String style) {
        super(s, false, elementId, style);
        this.addControl((Control)new MouseEventControl(FocusMouseListener.INSTANCE, new ButtonMouseHandler()));
        Styles styles = GuiGlobals.getInstance().getStyles();
        if (applyStyles) {
            styles.applyStyles((Object)this, elementId.getId(), style);
        }
    }

    @StyleDefaults(value="button")
    public static void initializeDefaultStyles(Attributes attrs) {
        attrs.set("background", new QuadBackgroundComponent(new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f)), false);
        attrs.set("highlightColor", ColorRGBA.Yellow, false);
        attrs.set("shadowColor", new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f), false);
    }

    public void addCommands(ButtonAction a, Command<? super Button> ... commands) {
        this.commandMap.addCommands(a, commands);
    }

    public List<Command<? super Button>> getCommands(ButtonAction a) {
        return this.commandMap.get(a, false);
    }

    public void addClickCommands(Command<? super Button> ... commands) {
        this.commandMap.addCommands(ButtonAction.Click, commands);
    }

    public void removeClickCommands(Command<? super Button> ... commands) {
        this.getClickCommands().removeAll(Arrays.asList(commands));
    }

    public List<Command<? super Button>> getClickCommands() {
        return this.commandMap.get(ButtonAction.Click, false);
    }

    @StyleAttribute(value="buttonCommands")
    public void setButtonCommands(Map<ButtonAction, List<Command<? super Button>>> map) {
        this.commandMap.clear();
        for (Map.Entry<ButtonAction, List<Command<? super Button>>> e : map.entrySet()) {
            this.commandMap.addCommands(e.getKey(), (Collection<Command<Button>>)e.getValue());
        }
    }

    @Override
    @StyleAttribute(value="color")
    public void setColor(ColorRGBA color) {
        this.color = color;
        super.setColor(color);
    }

    @Override
    public ColorRGBA getColor() {
        return this.color;
    }

    @Override
    @StyleAttribute(value="shadowColor", lookupDefault=false)
    public void setShadowColor(ColorRGBA color) {
        this.shadowColor = color;
        super.setShadowColor(this.shadowColor);
    }

    @Override
    public ColorRGBA getShadowColor() {
        return this.shadowColor;
    }

    @StyleAttribute(value="highlightColor", lookupDefault=false)
    public void setHighlightColor(ColorRGBA color) {
        this.highlightColor = color;
    }

    public ColorRGBA getHighlightColor() {
        return this.highlightColor;
    }

    @StyleAttribute(value="highlightShadowColor", lookupDefault=false)
    public void setHighlightShadowColor(ColorRGBA color) {
        this.highlightShadowColor = color;
    }

    public ColorRGBA getHighlightShadowColor() {
        return this.highlightShadowColor;
    }

    public void setEnabled(boolean b) {
        if (this.enabled == b) {
            return;
        }
        this.enabled = b;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public boolean isHighlightOn() {
        return this.highlightOn;
    }

    protected void showHighlight(boolean f) {
        this.highlightOn = f;
        if (f) {
            if (this.getHighlightColor() != null) {
                super.setColor(this.getHighlightColor());
            }
            if (this.getHighlightShadowColor() != null) {
                super.setShadowColor(this.getHighlightShadowColor());
            }
        } else {
            super.setColor(this.getColor());
            super.setShadowColor(this.getShadowColor());
        }
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "[text=" + this.getText() + ", color=" + this.getColor() + ", elementId=" + this.getElementId() + "]";
    }

    protected class ButtonMouseHandler
    extends DefaultMouseListener {
        protected ButtonMouseHandler() {
        }

        @Override
        protected void click(MouseButtonEvent event, Spatial target, Spatial capture) {
            if (!Button.this.isEnabled()) {
                return;
            }
            Button.this.commandMap.runCommands(ButtonAction.Click);
            Button.this.runEffect(Button.EFFECT_CLICK);
        }

        @Override
        public void mouseButtonEvent(MouseButtonEvent event, Spatial target, Spatial capture) {
            event.setConsumed();
            if (!Button.this.isEnabled()) {
                return;
            }
            Button.this.pressed = event.isPressed();
            if (event.isPressed()) {
                Button.this.commandMap.runCommands(ButtonAction.Down);
                Button.this.runEffect(Button.EFFECT_PRESS);
            } else {
                if (target == capture) {
                    this.click(event, target, capture);
                }
                if (capture == Button.this) {
                    Button.this.commandMap.runCommands(ButtonAction.Up);
                    Button.this.runEffect(Button.EFFECT_RELEASE);
                }
            }
        }

        @Override
        public void mouseEntered(MouseMotionEvent event, Spatial target, Spatial capture) {
            if (!Button.this.isEnabled()) {
                return;
            }
            if (capture == Button.this || target == Button.this && capture == null) {
                Button.this.showHighlight(true);
                Button.this.commandMap.runCommands(ButtonAction.HighlightOn);
                Button.this.runEffect(Button.EFFECT_ACTIVATE);
            }
        }

        @Override
        public void mouseExited(MouseMotionEvent event, Spatial target, Spatial capture) {
            if (!Button.this.isEnabled()) {
                return;
            }
            Button.this.showHighlight(false);
            Button.this.commandMap.runCommands(ButtonAction.HighlightOff);
            Button.this.runEffect(Button.EFFECT_DEACTIVATE);
        }
    }

    public static enum ButtonAction {
        Down,
        Up,
        Click,
        HighlightOn,
        HighlightOff;

    }
}

