/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class DocumentModel
implements VersionedObject<DocumentModel> {
    private long version;
    private List<StringBuilder> lines = new ArrayList<StringBuilder>();
    private String composite = null;
    private int carat = 0;
    private int line = 0;
    private int column = 0;

    public DocumentModel() {
        this.parseText("");
    }

    public DocumentModel(String text) {
        this.parseText(text != null ? text : "");
    }

    public void setText(String text) {
        this.parseText(text != null ? text : "");
    }

    public String getText() {
        if (this.composite == null) {
            this.createComposite();
        }
        return this.composite;
    }

    public String getLine(int line) {
        return this.lines.get(line).toString();
    }

    public int getLineCount() {
        return this.lines.size();
    }

    public int getCarat() {
        return this.carat;
    }

    public int getCaratLine() {
        return this.line;
    }

    public int getCaratColumn() {
        return this.column;
    }

    public int getAnchorLine() {
        return this.getCaratLine();
    }

    public int getAnchorColumn() {
        return this.getCaratColumn();
    }

    public int getAnchor() {
        return this.getCarat();
    }

    public int home(boolean currentLine) {
        if (currentLine) {
            this.carat -= this.column;
            this.column = 0;
        } else {
            this.carat = 0;
            this.column = 0;
            this.line = 0;
        }
        return this.carat;
    }

    public int end(boolean currentLine) {
        if (currentLine) {
            StringBuilder row = this.lines.get(this.line);
            this.carat += row.length() - this.column;
            this.column = row.length();
        } else {
            this.carat = 0;
            this.column = 0;
            this.line = 0;
            for (int i = 0; i < this.lines.size(); ++i) {
                if (i > 0) {
                    ++this.carat;
                }
                StringBuilder row = this.lines.get(i);
                this.carat += row.length();
                this.column = row.length();
            }
            this.line = this.lines.size() - 1;
        }
        return this.carat;
    }

    public int up() {
        if (this.line == 0) {
            return this.carat;
        }
        this.carat -= this.column;
        --this.line;
        --this.carat;
        if (this.column <= this.lines.get(this.line).length()) {
            this.carat -= this.lines.get(this.line).length() - this.column;
        } else {
            this.column = this.lines.get(this.line).length();
        }
        return this.carat;
    }

    public int down() {
        if (this.line == this.lines.size() - 1) {
            return this.carat;
        }
        int restOfLine = this.lines.get(this.line).length() - this.column;
        this.carat += restOfLine;
        ++this.line;
        ++this.carat;
        this.column = Math.min(this.column, this.lines.get(this.line).length());
        this.carat += this.column;
        return this.carat;
    }

    public int left() {
        if (this.carat == 0) {
            return 0;
        }
        --this.carat;
        --this.column;
        if (this.column < 0) {
            --this.line;
            if (this.line < 0) {
                System.out.println("How did this happen?  carat:" + this.carat);
            }
            this.column = this.lines.get(this.line).length();
        }
        return this.carat;
    }

    public int right() {
        ++this.column;
        ++this.carat;
        if (this.column > this.lines.get(this.line).length()) {
            if (this.line < this.lines.size() - 1) {
                ++this.line;
                this.column = 0;
            } else {
                --this.column;
                --this.carat;
            }
        }
        return this.carat;
    }

    public void insertNewLine() {
        if (this.line == this.lines.size() - 1 && this.column == this.lines.get(this.line).length()) {
            this.lines.add(new StringBuilder());
        } else {
            StringBuilder row = this.lines.get(this.line);
            StringBuilder next = new StringBuilder(row.substring(this.column));
            row.delete(this.column, row.length());
            this.lines.add(this.line + 1, next);
        }
        ++this.line;
        this.column = 0;
        ++this.carat;
        this.composite = null;
        ++this.version;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteCharAt(int pos) {
        if (pos == this.carat - 1) {
            this.backspace();
            return;
        }
        if (pos == this.carat) {
            this.delete();
            return;
        }
        int[] location = new int[2];
        this.findPosition(pos, location);
        if (location[0] >= this.lines.size()) {
            return;
        }
        StringBuilder row = this.lines.get(location[0]);
        if (location[1] == row.length()) {
            if (location[0] >= this.lines.size() - 1) return;
            row.append((CharSequence)this.lines.get(location[0] + 1));
            this.lines.remove(location[0] + 1);
        } else {
            row.deleteCharAt(location[1]);
        }
        if (this.carat <= pos) {
            --this.carat;
            this.findPosition(this.carat, location);
            this.line = location[0];
            this.column = location[1];
        }
        this.composite = null;
        ++this.version;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void backspace() {
        if (this.carat == 0) {
            return;
        }
        if (this.column == 0) {
            if (this.line <= 0) return;
            this.column = this.lines.get(this.line - 1).length();
            this.lines.get(this.line - 1).append((CharSequence)this.lines.remove(this.line));
            --this.carat;
            --this.line;
        } else {
            StringBuilder row = this.lines.get(this.line);
            row.deleteCharAt(this.column - 1);
            --this.column;
            --this.carat;
        }
        this.composite = null;
        ++this.version;
    }

    public void delete() {
        StringBuilder row = this.lines.get(this.line);
        if (this.column == row.length()) {
            if (this.line >= this.lines.size() - 1) {
                return;
            }
            row.append((CharSequence)this.lines.remove(this.line + 1));
        } else {
            row.deleteCharAt(this.column);
        }
        this.composite = null;
        ++this.version;
    }

    protected void findPosition(int pos, int[] location) {
        int index = 0;
        location[0] = 0;
        location[1] = 0;
        for (int r = 0; r < this.lines.size(); ++r) {
            StringBuilder l = this.lines.get(r);
            if (pos - index <= l.length()) {
                location[0] = r;
                location[1] = pos - index;
                return;
            }
            index += l.length() + 1;
        }
        location[0] = this.lines.size();
        location[1] = 0;
    }

    public void insert(char c) {
        if (c < ' ') {
            return;
        }
        switch (c) {
            default: 
        }
        this.lines.get(this.line).insert(this.column, c);
        ++this.carat;
        ++this.column;
        this.composite = null;
        ++this.version;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public DocumentModel getObject() {
        return this;
    }

    @Override
    public VersionedReference<DocumentModel> createReference() {
        return new VersionedReference<DocumentModel>(this);
    }

    protected void parseText(String text) {
        this.composite = null;
        this.lines.clear();
        StringTokenizer st = new StringTokenizer(text, "\r\n");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            this.lines.add(new StringBuilder(token));
        }
        if (this.lines.isEmpty()) {
            this.lines.add(new StringBuilder());
        }
        this.end(false);
        ++this.version;
    }

    protected void createComposite() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.lines.size(); ++i) {
            sb.append((CharSequence)this.lines.get(i));
            if (i >= this.lines.size() - 1) continue;
            sb.append("\n");
        }
        this.composite = sb.toString();
    }

    public String toString() {
        return "DocumentModel[]";
    }
}

