/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.event;

import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import com.simsilica.lemur.event.CursorButtonEvent;
import com.simsilica.lemur.event.CursorListener;
import com.simsilica.lemur.event.CursorMotionEvent;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class CursorEventControl
extends AbstractControl {
    private List<CursorListener> listeners = new CopyOnWriteArrayList<CursorListener>();

    public CursorEventControl() {
    }

    public CursorEventControl(CursorListener ... listeners) {
        this.listeners.addAll(Arrays.asList(listeners));
    }

    public static void addListenersToSpatial(Spatial s, CursorListener ... listeners) {
        if (s == null) {
            return;
        }
        CursorEventControl mec = (CursorEventControl)s.getControl(CursorEventControl.class);
        if (mec == null) {
            s.addControl((Control)new CursorEventControl(listeners));
        } else {
            mec.listeners.addAll(Arrays.asList(listeners));
        }
    }

    public static void removeListenersFromSpatial(Spatial s, CursorListener ... listeners) {
        if (s == null) {
            return;
        }
        CursorEventControl mec = (CursorEventControl)s.getControl(CursorEventControl.class);
        if (mec == null) {
            return;
        }
        mec.listeners.removeAll(Arrays.asList(listeners));
    }

    public <T extends CursorListener> T getMouseListener(Class<T> type) {
        for (CursorListener l : this.listeners) {
            if (l.getClass() != type) continue;
            return (T)l;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void addMouseListener(CursorListener l) {
        this.listeners.add(l);
    }

    public void removeMouseListener(CursorListener l) {
        this.listeners.remove(l);
    }

    public void cursorButtonEvent(CursorButtonEvent event, Spatial target, Spatial capture) {
        for (CursorListener l : this.listeners) {
            l.cursorButtonEvent(event, target, capture);
        }
    }

    public void cursorEntered(CursorMotionEvent event, Spatial target, Spatial capture) {
        for (CursorListener l : this.listeners) {
            l.cursorEntered(event, target, capture);
        }
    }

    public void cursorExited(CursorMotionEvent event, Spatial target, Spatial capture) {
        for (CursorListener l : this.listeners) {
            l.cursorExited(event, target, capture);
        }
    }

    public void cursorMoved(CursorMotionEvent event, Spatial target, Spatial capture) {
        for (CursorListener l : this.listeners) {
            l.cursorMoved(event, target, capture);
        }
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
    }

    protected void controlUpdate(float tpf) {
    }
}

