/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.event;

import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.math.Ray;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import com.jme3.util.SafeArrayList;
import com.simsilica.lemur.event.AbstractCursorEvent;
import com.simsilica.lemur.event.CursorButtonEvent;
import com.simsilica.lemur.event.CursorEventControl;
import com.simsilica.lemur.event.CursorMotionEvent;
import com.simsilica.lemur.event.MouseEventControl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class PickEventSession {
    private Map<Collidable, RootEntry> roots = new LinkedHashMap<Collidable, RootEntry>();
    private SafeArrayList<RootEntry> rootList = new SafeArrayList(RootEntry.class);
    private Map<Camera, Ray> rayCache = new HashMap<Camera, Ray>();
    private Spatial hitTarget;
    private Spatial capture;
    private Set<Spatial> delivered = new HashSet<Spatial>();

    public PickEventSession() {
    }

    protected PickEventSession(Map<Collidable, RootEntry> roots) {
        this.roots.putAll(roots);
        this.rootList = null;
    }

    public PickEventSession clone() {
        return new PickEventSession(this.roots);
    }

    public ViewPort findViewPort(Spatial s) {
        if (s == null) {
            return null;
        }
        for (Spatial root = s; root != null; root = root.getParent()) {
            RootEntry e = this.roots.get(root);
            if (e == null) continue;
            return e.viewport;
        }
        return null;
    }

    public void addCollisionRoot(ViewPort viewPort) {
        for (Spatial s : viewPort.getScenes()) {
            this.addCollisionRoot(s, viewPort);
        }
    }

    public void addCollisionRoot(Spatial root, ViewPort viewPort) {
        this.roots.put((Collidable)root, new RootEntry((Collidable)root, viewPort));
        this.rootList = null;
    }

    public void removeCollisionRoot(ViewPort viewPort) {
        for (Spatial s : viewPort.getScenes()) {
            this.removeCollisionRoot(s);
        }
    }

    public void removeCollisionRoot(Spatial root) {
        RootEntry e = this.roots.remove(root);
        this.rootList = null;
    }

    public void clearHitTarget() {
        if (this.hitTarget == null) {
            return;
        }
        this.setCurrentHitTarget(null, null, new Vector2f(-1.0f, -1.0f), null);
    }

    public void close() {
        this.clearHitTarget();
        this.capture = null;
        this.rayCache.clear();
        this.delivered.clear();
        this.roots.clear();
        this.rootList = null;
    }

    protected Spatial findHitTarget(Spatial hit) {
        for (Spatial s = hit; s != null; s = s.getParent()) {
            CursorEventControl control1 = (CursorEventControl)s.getControl(CursorEventControl.class);
            if (control1 != null && control1.isEnabled()) {
                return s;
            }
            MouseEventControl control2 = (MouseEventControl)s.getControl(MouseEventControl.class);
            if (control2 == null || !control2.isEnabled()) continue;
            return s;
        }
        return null;
    }

    protected void setCurrentHitTarget(ViewPort viewport, Spatial s, Vector2f cursor, CollisionResult cr) {
        if (this.hitTarget == s) {
            return;
        }
        CursorMotionEvent event1 = null;
        MouseMotionEvent event2 = null;
        if (this.hitTarget != null) {
            if (this.hitTarget.getControl(MouseEventControl.class) != null) {
                event2 = new MouseMotionEvent((int)cursor.x, (int)cursor.y, 0, 0, 0, 0);
                ((MouseEventControl)this.hitTarget.getControl(MouseEventControl.class)).mouseExited(event2, this.hitTarget, this.capture);
            }
            if (this.hitTarget.getControl(CursorEventControl.class) != null) {
                event1 = new CursorMotionEvent(viewport, this.hitTarget, cursor.x, cursor.y, null);
                ((CursorEventControl)this.hitTarget.getControl(CursorEventControl.class)).cursorExited(event1, this.hitTarget, this.capture);
            }
        }
        this.hitTarget = s;
        if (this.hitTarget != null) {
            if (this.hitTarget.getControl(MouseEventControl.class) != null) {
                if (event2 == null) {
                    event2 = new MouseMotionEvent((int)cursor.x, (int)cursor.y, 0, 0, 0, 0);
                }
                ((MouseEventControl)this.hitTarget.getControl(MouseEventControl.class)).mouseEntered(event2, this.hitTarget, this.capture);
            }
            if (this.hitTarget.getControl(CursorEventControl.class) != null) {
                if (event1 == null) {
                    event1 = new CursorMotionEvent(viewport, this.hitTarget, cursor.x, cursor.y, null);
                }
                ((CursorEventControl)this.hitTarget.getControl(CursorEventControl.class)).cursorEntered(event1, this.hitTarget, this.capture);
            }
        }
    }

    protected SafeArrayList<RootEntry> getRootList() {
        if (this.rootList == null) {
            this.rootList = new SafeArrayList(RootEntry.class);
            for (RootEntry e : this.roots.values()) {
                this.rootList.add(0, (Object)e);
            }
        }
        return this.rootList;
    }

    protected Ray getPickRay(Camera cam, Vector2f cursor) {
        Ray result = this.rayCache.get(cam);
        if (result != null) {
            return result;
        }
        if (cam.isParallelProjection()) {
            result = new Ray(new Vector3f(cursor.x, cursor.y, 1000.0f), new Vector3f(0.0f, 0.0f, -1.0f));
        } else {
            Vector3f clickFar = cam.getWorldCoordinates(cursor, 1.0f);
            Vector3f clickNear = cam.getWorldCoordinates(cursor, 0.0f);
            result = new Ray(clickNear, clickFar.subtractLocal(clickNear).normalizeLocal());
        }
        this.rayCache.put(cam, result);
        return result;
    }

    public boolean cursorMoved(int x, int y) {
        Vector2f cursor = new Vector2f((float)x, (float)y);
        CollisionResults results = new CollisionResults();
        Spatial firstHit = null;
        MouseMotionEvent event = null;
        Object target = null;
        this.rayCache.clear();
        this.delivered.clear();
        if (this.capture != null) {
            boolean consumed = false;
            if (this.capture.getControl(MouseEventControl.class) != null) {
                event = new MouseMotionEvent((int)cursor.x, (int)cursor.y, 0, 0, 0, 0);
                this.delivered.add(this.capture);
                ((MouseEventControl)this.capture.getControl(MouseEventControl.class)).mouseMoved(event, this.capture, this.capture);
                if (event.isConsumed()) {
                    consumed = true;
                }
            }
            if (this.capture.getControl(CursorEventControl.class) != null) {
                ViewPort captureView = this.findViewPort(this.capture);
                if (captureView == null) {
                    return consumed;
                }
                Ray mouseRay = this.getPickRay(captureView.getCamera(), cursor);
                int count = this.capture.collideWith((Collidable)mouseRay, results);
                CollisionResult cr = null;
                if (count > 0) {
                    cr = results.getClosestCollision();
                    results.clear();
                }
                CursorMotionEvent cme = new CursorMotionEvent(captureView, this.capture, cursor.x, cursor.y, cr);
                this.delivered.add(this.capture);
                ((CursorEventControl)this.capture.getControl(CursorEventControl.class)).cursorMoved(cme, this.capture, this.capture);
                if (cme.isConsumed()) {
                    consumed = true;
                }
            }
            if (consumed) {
                return true;
            }
        }
        for (RootEntry e : (RootEntry[])this.getRootList().getArray()) {
            Camera cam = e.viewport.getCamera();
            Ray mouseRay = this.getPickRay(cam, cursor);
            int count = e.root.collideWith((Collidable)mouseRay, results);
            if (count > 0) {
                for (CollisionResult cr : results) {
                    Geometry geom = cr.getGeometry();
                    Spatial hit = this.findHitTarget((Spatial)geom);
                    if (hit == null) continue;
                    if (firstHit == null) {
                        this.setCurrentHitTarget(e.viewport, hit, cursor, cr);
                        firstHit = hit;
                    }
                    if (!this.delivered.add(hit)) continue;
                    boolean consumed = false;
                    if (hit.getControl(MouseEventControl.class) != null) {
                        if (event == null) {
                            event = new MouseMotionEvent((int)cursor.x, (int)cursor.y, 0, 0, 0, 0);
                        }
                        ((MouseEventControl)hit.getControl(MouseEventControl.class)).mouseMoved(event, hit, this.capture);
                        if (event.isConsumed()) {
                            consumed = true;
                        }
                    }
                    if (hit.getControl(CursorEventControl.class) != null) {
                        CursorMotionEvent cme = new CursorMotionEvent(e.viewport, hit, cursor.x, cursor.y, cr);
                        ((CursorEventControl)hit.getControl(CursorEventControl.class)).cursorMoved(cme, hit, this.capture);
                        if (cme.isConsumed()) {
                            consumed = true;
                        }
                    }
                    if (!consumed) continue;
                    return true;
                }
            }
            results.clear();
        }
        if (firstHit == null) {
            this.setCurrentHitTarget(null, null, cursor, null);
        }
        return false;
    }

    public boolean buttonEvent(int buttonIndex, int x, int y, boolean pressed) {
        AbstractCursorEvent event1 = null;
        MouseButtonEvent event2 = null;
        this.cursorMoved(x, y);
        if (pressed) {
            this.capture = this.hitTarget;
        } else if (this.capture != null) {
            Spatial tempCapture = this.capture;
            this.capture = null;
            boolean consumed = false;
            if (tempCapture.getControl(MouseEventControl.class) != null) {
                event2 = new MouseButtonEvent(buttonIndex, pressed, x, y);
                ((MouseEventControl)tempCapture.getControl(MouseEventControl.class)).mouseButtonEvent(event2, this.hitTarget, tempCapture);
                if (event2.isConsumed()) {
                    consumed = true;
                }
            }
            if (tempCapture.getControl(CursorEventControl.class) != null) {
                event1 = new CursorButtonEvent(buttonIndex, pressed, this.findViewPort(this.hitTarget), this.hitTarget, x, y, null);
                ((CursorEventControl)tempCapture.getControl(CursorEventControl.class)).cursorButtonEvent((CursorButtonEvent)event1, this.hitTarget, tempCapture);
                if (event1.isConsumed()) {
                    consumed = true;
                }
            }
            if (consumed) {
                return true;
            }
            if (tempCapture == this.hitTarget) {
                return false;
            }
        }
        if (this.hitTarget == null) {
            return false;
        }
        boolean consumed = false;
        if (this.hitTarget.getControl(MouseEventControl.class) != null) {
            if (event2 == null) {
                event2 = new MouseButtonEvent(buttonIndex, pressed, x, y);
            }
            ((MouseEventControl)this.hitTarget.getControl(MouseEventControl.class)).mouseButtonEvent(event2, this.hitTarget, this.capture);
            if (event2.isConsumed()) {
                consumed = true;
            }
        }
        if (this.hitTarget.getControl(CursorEventControl.class) != null) {
            if (event1 == null) {
                event1 = new CursorButtonEvent(buttonIndex, pressed, this.findViewPort(this.hitTarget), this.hitTarget, x, y, null);
            }
            ((CursorEventControl)this.hitTarget.getControl(CursorEventControl.class)).cursorButtonEvent((CursorButtonEvent)event1, this.hitTarget, this.capture);
            if (event1.isConsumed()) {
                consumed = true;
            }
        }
        return consumed;
    }

    public static class RootEntry {
        public ViewPort viewport;
        public Collidable root;

        public RootEntry(Collidable root, ViewPort viewport) {
            this.viewport = viewport;
            this.root = root;
        }

        public String toString() {
            return "RootEntry[viewport=" + this.viewport + ", root=" + this.root + "]";
        }
    }
}

