/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.geom;

import com.jme3.math.Vector3f;
import com.simsilica.lemur.geom.Deformation;

public class Deformations {
    public static Ramp ramp(int majorAxis, int minorAxis, float scale) {
        return new Ramp(majorAxis, minorAxis, scale);
    }

    public static Cylindrical cylindrical(int majorAxis, int minorAxis, Vector3f origin, float radius, float start, float limit) {
        return new Cylindrical(majorAxis, minorAxis, origin, radius, start, limit);
    }

    public static class Cylindrical
    implements Deformation {
        private Vector3f origin;
        private float radius;
        private int majorAxis;
        private int minorAxis;
        private float start;
        private float limit;

        public Cylindrical(int majorAxis, int minorAxis, Vector3f origin, float radius, float start, float limit) {
            this.majorAxis = majorAxis;
            this.minorAxis = minorAxis;
            this.origin = origin;
            this.radius = radius;
            this.start = start;
            this.limit = limit;
        }

        public void setOrigin(Vector3f origin) {
            this.origin = origin;
        }

        public Vector3f getOrigin() {
            return this.origin;
        }

        public void setRadius(float radius) {
            this.radius = radius;
        }

        public float getRadius() {
            return this.radius;
        }

        public void setStart(float start) {
            this.start = start;
        }

        public float getStart() {
            return this.start;
        }

        public void setLimit(float limit) {
            this.limit = limit;
        }

        public float getLimit() {
            return this.limit;
        }

        @Override
        public void deform(Vector3f vert, Vector3f normal) {
            float x = vert.get(this.minorAxis) - this.origin.get(this.minorAxis);
            float base = Math.min(this.origin.get(this.majorAxis), this.start);
            float y = vert.get(this.majorAxis) - base;
            if (y < 0.0f) {
                return;
            }
            float projection = 0.0f;
            if (y > this.limit) {
                projection = y - this.limit;
                y = this.limit;
            }
            float rads = y / this.radius;
            if (x < 0.0f) {
                rads = (float)Math.PI - rads;
            }
            float xd = (float)Math.cos(rads);
            float yd = (float)Math.sin(rads);
            float r = Math.abs(x);
            vert.set(this.minorAxis, this.origin.get(this.minorAxis) + xd * r);
            vert.set(this.majorAxis, base + yd * r);
            float xRight = xd;
            float yRight = yd;
            float xUp = -yd;
            float yUp = xd;
            if (x < 0.0f) {
                xRight *= -1.0f;
                yRight *= -1.0f;
                xUp *= -1.0f;
                yUp *= -1.0f;
            }
            float nx = xUp * normal.get(this.majorAxis);
            float ny = yUp * normal.get(this.majorAxis);
            normal.set(this.minorAxis, nx += xRight * normal.get(this.minorAxis));
            normal.set(this.majorAxis, ny += yRight * normal.get(this.minorAxis));
            if (projection > 0.0f) {
                float vx = vert.get(this.minorAxis) + xUp * projection;
                float vy = vert.get(this.majorAxis) + yUp * projection;
                vert.set(this.minorAxis, vx);
                vert.set(this.majorAxis, vy);
            }
        }
    }

    public static class Ramp
    implements Deformation {
        private int majorAxis;
        private int minorAxis;
        private float scale;

        public Ramp(int majorAxis, int minorAxis, float scale) {
            this.majorAxis = majorAxis;
            this.minorAxis = minorAxis;
            this.scale = scale;
        }

        @Override
        public void deform(Vector3f vert, Vector3f normal) {
            float major = vert.get(this.majorAxis);
            float minor = vert.get(this.minorAxis);
            vert.set(this.minorAxis, minor += major * this.scale);
        }
    }
}

