/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.DefaultRangedValueModel;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.RangedValueModel;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.Attributes;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.style.StyleDefaults;
import com.simsilica.lemur.style.Styles;

public class ProgressBar
extends Panel {
    public static final String ELEMENT_ID = "progress";
    public static final String CONTAINER_ID = "container";
    public static final String LABEL_ID = "label";
    public static final String VALUE_ID = "value";
    private BorderLayout layout;
    private Label label;
    private Panel value;
    private RangedValueModel model;
    private VersionedReference<Double> state;

    public ProgressBar() {
        this(new DefaultRangedValueModel(), true, new ElementId(ELEMENT_ID), null);
    }

    public ProgressBar(String style) {
        this(new DefaultRangedValueModel(), true, new ElementId(ELEMENT_ID), style);
    }

    public ProgressBar(ElementId elementId, String style) {
        this(new DefaultRangedValueModel(), true, elementId, style);
    }

    public ProgressBar(RangedValueModel model) {
        this(model, true, new ElementId(ELEMENT_ID), null);
    }

    public ProgressBar(RangedValueModel model, String style) {
        this(model, true, new ElementId(ELEMENT_ID), style);
    }

    protected ProgressBar(RangedValueModel model, boolean applyStyles, ElementId elementId, String style) {
        super(false, elementId.child(CONTAINER_ID), style);
        this.model = model;
        Styles styles = GuiGlobals.getInstance().getStyles();
        styles.initializeStyles(((Object)((Object)this)).getClass());
        this.layout = new BorderLayout();
        ((GuiControl)this.getControl(GuiControl.class)).setLayout(this.layout);
        this.label = this.layout.addChild(new Label("", elementId.child(LABEL_ID), style), new Object[0]);
        this.value = new Panel(elementId.child(VALUE_ID), style);
        this.attachChild((Spatial)this.value);
        if (applyStyles) {
            styles.applyStyles((Object)this, this.getElementId(), style);
        }
    }

    @StyleDefaults(value="progress")
    public static void initializeDefaultStyles(Styles styles, Attributes attrs) {
        ElementId parent = new ElementId(ELEMENT_ID);
        styles.getSelector(parent.child(CONTAINER_ID), null).set("background", new QuadBackgroundComponent(new ColorRGBA(0.2f, 0.2f, 0.2f, 0.5f), 2.0f, 2.0f));
        styles.getSelector(parent.child(VALUE_ID), null).set("background", new QuadBackgroundComponent(new ColorRGBA(0.1f, 0.7f, 0.3f, 1.0f)));
        styles.getSelector(parent.child(LABEL_ID), null).set("textHAlignment", (Object)HAlignment.Center, false);
    }

    public void setProgressPercent(double percent) {
        this.model.setPercent(percent);
    }

    public double getProgressPercent() {
        return this.model.getPercent();
    }

    public void setProgressValue(double val) {
        this.model.setValue(val);
    }

    public double getProgressValue() {
        return this.model.getValue();
    }

    public void setModel(RangedValueModel model) {
        if (this.model == model) {
            return;
        }
        if (model == null) {
            model = new DefaultRangedValueModel();
        }
        this.model = model;
        this.state = null;
    }

    public RangedValueModel getModel() {
        return this.model;
    }

    public void setMessage(String message) {
        this.label.setText(message);
    }

    public String getMessage() {
        return this.label.getText();
    }

    public Label getLabel() {
        return this.label;
    }

    public Panel getValueIndicator() {
        return this.value;
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.state == null || this.state.update()) {
            this.resetStateView();
        }
    }

    protected void resetStateView() {
        if (this.state == null) {
            this.state = this.model.createReference();
        }
        Vector3f labelSize = this.label.getSize();
        Vector3f labelPos = this.label.getLocalTranslation();
        double width = this.model.getPercent() * (double)labelSize.x;
        this.value.setSize(new Vector3f((float)width, labelSize.y, labelSize.z));
        this.value.setLocalTranslation(labelPos.x, labelPos.y, labelPos.z * 0.5f);
    }
}

