/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.anim;

import com.simsilica.lemur.anim.Animation;
import com.simsilica.lemur.anim.Tween;
import com.simsilica.lemur.anim.Tweens;

public class TweenAnimation
implements Animation {
    private Tween delegate;
    private double t = -1.0;
    private boolean running = true;
    private boolean loop;

    public TweenAnimation(Tween ... delegates) {
        this(false, delegates);
    }

    public TweenAnimation(boolean loop, Tween ... delegates) {
        this.delegate = Tweens.sequence(delegates);
        this.loop = loop;
    }

    public boolean isLooping() {
        return this.loop;
    }

    public boolean isRunning() {
        return this.loop && this.running && this.t >= 0.0;
    }

    public double getLength() {
        return this.delegate.getLength();
    }

    public double getTime() {
        return this.t;
    }

    public double getRemaining() {
        if (this.t < 0.0) {
            return this.delegate.getLength();
        }
        return Math.max(0.0, this.delegate.getLength() - this.t);
    }

    public double getPercentRemaining() {
        return this.getRemaining() / this.delegate.getLength();
    }

    public void fastForwardPercent(double t) {
        this.fastForward(t * this.delegate.getLength());
    }

    public void fastForward(double t) {
        if (t < 0.0) {
            return;
        }
        if (t < this.t) {
            return;
        }
        if (this.t < 0.0) {
            this.animate(0.0);
        }
        this.animate(t);
    }

    @Override
    public boolean animate(double tpf) {
        if (!this.running) {
            return false;
        }
        this.t = this.t < 0.0 ? 0.0 : (this.t += tpf);
        if (this.loop) {
            if (!this.delegate.interpolate(this.t)) {
                this.t -= this.delegate.getLength();
                if (this.t > 0.0) {
                    this.delegate.interpolate(this.t);
                }
            }
        } else {
            this.running = this.delegate.interpolate(this.t);
        }
        return this.running;
    }

    @Override
    public void cancel() {
        this.running = false;
    }
}

