/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.focus;

import com.jme3.app.Application;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.simsilica.lemur.event.BaseAppState;
import com.simsilica.lemur.focus.FocusTarget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FocusManagerState
extends BaseAppState {
    private Spatial focus;
    private List<Spatial> focusHierarchy = Collections.emptyList();

    public FocusManagerState() {
        this.setEnabled(true);
    }

    public static FocusTarget findFocusTarget(Spatial s) {
        if (s == null) {
            return null;
        }
        for (int i = 0; i < s.getNumControls(); ++i) {
            Control c = s.getControl(i);
            if (!(c instanceof FocusTarget)) continue;
            return (FocusTarget)c;
        }
        return null;
    }

    public void setFocus(Spatial focus) {
        if (this.focus == focus) {
            return;
        }
        this.focus = focus;
        if (this.isEnabled()) {
            this.updateFocusHierarchy();
        }
    }

    public Spatial getFocus() {
        return this.focus;
    }

    @Override
    protected void initialize(Application app) {
    }

    @Override
    protected void cleanup(Application app) {
    }

    protected List<Spatial> getHierarchy(Spatial s) {
        if (s == null) {
            return Collections.emptyList();
        }
        ArrayList<Spatial> result = new ArrayList<Spatial>();
        while (s != null) {
            result.add(0, s);
            s = s.getParent();
        }
        return result;
    }

    protected void updateFocusHierarchy() {
        FocusTarget target;
        int i;
        List<Spatial> oldHierarchy = this.focusHierarchy;
        List<Spatial> newHierarchy = this.getHierarchy(this.focus);
        int lca = -1;
        int commonLength = Math.min(oldHierarchy.size(), newHierarchy.size());
        for (i = 0; i < commonLength; ++i) {
            Spatial s2;
            Spatial s1 = oldHierarchy.get(i);
            if (s1 == (s2 = newHierarchy.get(i))) continue;
            lca = i - 1;
            break;
        }
        for (i = lca + 1; i < oldHierarchy.size(); ++i) {
            target = FocusManagerState.findFocusTarget(oldHierarchy.get(i));
            if (target == null) continue;
            target.focusLost();
        }
        for (i = lca + 1; i < newHierarchy.size(); ++i) {
            target = FocusManagerState.findFocusTarget(newHierarchy.get(i));
            if (target == null) continue;
            target.focusGained();
        }
        this.focusHierarchy = newHierarchy;
    }

    @Override
    protected void enable() {
        for (Spatial s : this.focusHierarchy) {
            FocusTarget target = FocusManagerState.findFocusTarget(s);
            if (target == null) continue;
            target.focusGained();
        }
    }

    @Override
    protected void disable() {
        for (Spatial s : this.focusHierarchy) {
            FocusTarget target = FocusManagerState.findFocusTarget(s);
            if (target == null) continue;
            target.focusLost();
        }
    }
}

