/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.style;

import com.simsilica.lemur.style.Attributes;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.style.Styles;
import java.util.HashMap;
import java.util.Map;

public class StyleTree {
    private Styles styles;
    private Node root = new Node(null);

    public StyleTree(Styles styles) {
        this.styles = styles;
    }

    public Attributes getSelector(ElementId id, boolean create) {
        Node node = this.findChild(this.root, id.getParts(), create);
        if (node == null) {
            return null;
        }
        return node.getAttributes(create);
    }

    public Attributes getSelector(ElementId parent, ElementId child, boolean create) {
        Node nested = this.findChild(this.root, child.getParts(), create);
        if (nested == null) {
            return null;
        }
        Node wildCard = nested.getChild(null, create);
        if (wildCard == null) {
            return null;
        }
        Node node = this.findChild(wildCard, parent.getParts(), create);
        if (node == null) {
            return null;
        }
        return node.getAttributes(create);
    }

    public Attributes getAttributes(ElementId elementId) {
        Attributes results = new Attributes(this.styles);
        String[] parts = elementId.getParts();
        this.accumulateAttributes(this.root, parts, parts.length - 1, true, results);
        return results;
    }

    protected void accumulateAttributes(Node node, String[] parts, int index, boolean followWildCards, Attributes results) {
        Node wildCard;
        if (index < 0) {
            return;
        }
        String key = parts[index];
        Node child = node.getChild(key, false);
        if (child != null) {
            this.accumulateAttributes(child, parts, index - 1, followWildCards, results);
        }
        if (followWildCards && (wildCard = node.getChild(null, false)) != null) {
            for (int i = index; i >= 0; --i) {
                Node n = wildCard.getChild(parts[i], false);
                if (n == null) continue;
                this.accumulateAttributes(n, parts, i - 1, false, results);
                if (n.attributes == null) continue;
                results.applyNew(n.attributes);
            }
        }
        if (child != null && child.attributes != null) {
            results.applyNew(child.attributes);
        }
    }

    protected Node findChild(Node node, String[] parts, boolean create) {
        for (int i = parts.length - 1; i >= 0; --i) {
            if ((node = node.getChild(parts[i], create)) != null) continue;
            return null;
        }
        return node;
    }

    protected void dump(Node node, String indent) {
        System.out.println(indent + node + " {");
        if (node.children != null) {
            for (Node n : node.children.values()) {
                this.dump(n, indent + "    ");
            }
        }
        System.out.println(indent + "}");
    }

    protected void debug() {
        System.out.println("Style tree:");
        this.dump(this.root, "   ");
    }

    public static void main(String ... args) {
        Styles styles = new Styles();
        StyleTree tree = new StyleTree(styles);
        Attributes test1 = tree.getSelector(new ElementId("slider.up.button"), true);
        test1.set("foo", "123");
        test1.set("bar", "345");
        Attributes test2 = tree.getSelector(new ElementId("races.list"), new ElementId("up.button"), true);
        test2.set("bar", "789");
        test2.set("color", "lunch");
        Attributes test3 = tree.getSelector(new ElementId("button"), true);
        test3.set("color", "bacon");
        Attributes test4 = tree.getSelector(new ElementId("races.list"), new ElementId("slider.up.button"), true);
        test4.set("bar", "override");
        Attributes test5 = tree.getSelector(new ElementId("list"), new ElementId("up.button"), true);
        test5.set("baz", "arrow");
        tree.dump(tree.root, "");
        String[][] tests = new String[][]{{"slider.up.button", "foo=123, bar=345, color=bacon"}, {"races.list.slider.up.button", "foo=123, bar=override, color=lunch, baz=arrow"}, {"button", "color=bacon"}};
        for (int i = 0; i < tests.length; ++i) {
            Attributes attrs = tree.getAttributes(new ElementId(tests[i][0]));
            System.out.println("test [" + tests[i][0] + "] = " + attrs);
            System.out.println("    should be:" + tests[i][1]);
        }
    }

    protected class Node {
        private String id;
        private Attributes attributes;
        private Map<String, Node> children;

        public Node(String id) {
            this.id = id;
        }

        public Node getChild(String childId, boolean create) {
            Node result;
            if (this.children == null) {
                if (!create) {
                    return null;
                }
                this.children = new HashMap<String, Node>();
            }
            if ((result = this.children.get(childId)) == null && create) {
                result = new Node(childId);
                this.children.put(childId, result);
            }
            return result;
        }

        public Attributes getAttributes(boolean create) {
            if (this.attributes == null && create) {
                this.attributes = new Attributes(StyleTree.this.styles);
            }
            return this.attributes;
        }

        public String toString() {
            return "Node[" + (this.id == null ? "*" : this.id) + (this.attributes == null ? "" : ", " + this.attributes) + "]";
        }
    }
}

