/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.service.rpc;

import com.jme3.network.MessageConnection;
import com.jme3.network.service.rpc.RpcHandler;
import com.jme3.network.service.rpc.msg.RpcCallMessage;
import com.jme3.network.service.rpc.msg.RpcResponseMessage;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RpcConnection {
    static final Logger log = Logger.getLogger(RpcConnection.class.getName());
    private MessageConnection connection;
    private Map<Short, RpcHandler> handlers = new ConcurrentHashMap<Short, RpcHandler>();
    private AtomicLong sequenceNumber = new AtomicLong();
    private Map<Long, ResponseHolder> responses = new ConcurrentHashMap<Long, ResponseHolder>();

    public RpcConnection(MessageConnection connection) {
        this.connection = connection;
    }

    public void close() {
        for (ResponseHolder holder : this.responses.values()) {
            holder.release();
        }
    }

    public Object callAndWait(byte channel, short objId, short procId, Object ... args) {
        RpcCallMessage msg = new RpcCallMessage(this.sequenceNumber.getAndIncrement(), channel, objId, procId, args);
        ResponseHolder holder = new ResponseHolder(msg);
        this.responses.put(msg.getMessageId(), holder);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Sending:{0}  on channel:{1}", new Object[]{msg, channel});
        }
        if (channel >= 0) {
            this.connection.send(channel, msg);
        } else {
            this.connection.send(msg);
        }
        return holder.getResponse();
    }

    public void callAsync(byte channel, short objId, short procId, Object ... args) {
        RpcCallMessage msg = new RpcCallMessage(-1L, channel, objId, procId, args);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Sending:{0}  on channel:{1}", new Object[]{msg, channel});
        }
        this.connection.send(channel, msg);
    }

    public void registerHandler(short objId, RpcHandler handler) {
        this.handlers.put(objId, handler);
    }

    public void removeHandler(short objId, RpcHandler handler) {
        RpcHandler removing = this.handlers.get(objId);
        if (handler != removing) {
            throw new IllegalArgumentException("Handler not registered for object ID:" + objId + ", handler:" + handler);
        }
        this.handlers.remove(objId);
    }

    protected void send(byte channel, RpcResponseMessage msg) {
        if (channel >= 0) {
            this.connection.send(channel, msg);
        } else {
            this.connection.send(msg);
        }
    }

    public void handleMessage(RpcCallMessage msg) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "handleMessage({0})", msg);
        }
        RpcHandler handler = this.handlers.get(msg.getObjectId());
        try {
            if (handler == null) {
                throw new RuntimeException("Handler not found for objectID:" + msg.getObjectId());
            }
            Object result = handler.call(this, msg.getObjectId(), msg.getProcedureId(), msg.getArguments());
            if (!msg.isAsync()) {
                this.send(msg.getChannel(), new RpcResponseMessage(msg.getMessageId(), result));
            }
        }
        catch (Exception e) {
            if (!msg.isAsync()) {
                this.send(msg.getChannel(), new RpcResponseMessage(msg.getMessageId(), e));
            }
            log.log(Level.SEVERE, "Error invoking async call for:" + msg, e);
        }
    }

    public void handleMessage(RpcResponseMessage msg) {
        ResponseHolder holder;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "handleMessage({0})", msg);
        }
        if ((holder = this.responses.remove(msg.getMessageId())) == null) {
            return;
        }
        holder.setResponse(msg);
    }

    private class ResponseHolder {
        private Object response;
        private String error;
        private RpcCallMessage msg;
        boolean received = false;

        public ResponseHolder(RpcCallMessage msg) {
            this.msg = msg;
        }

        public synchronized void setResponse(RpcResponseMessage msg) {
            this.response = msg.getResult();
            this.error = msg.getError();
            this.received = true;
            this.notifyAll();
        }

        public synchronized Object getResponse() {
            try {
                while (!this.received) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted waiting for respone to:" + this.msg, e);
            }
            if (this.error != null) {
                throw new RuntimeException("Error calling remote procedure:" + this.msg + "\n" + this.error);
            }
            return this.response;
        }

        public synchronized void release() {
            if (this.received) {
                return;
            }
            this.error = "Closing connection";
            this.received = true;
        }
    }
}

