/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer.lwjgl;

import com.jme3.renderer.RendererException;
import com.jme3.renderer.opengl.GLExt;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.ARBDrawInstanced;
import org.lwjgl.opengl.ARBInstancedArrays;
import org.lwjgl.opengl.ARBSync;
import org.lwjgl.opengl.ARBTextureMultisample;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GLSync;

public class LwjglGLExt
implements GLExt {
    private static void checkLimit(Buffer buffer) {
        if (buffer == null) {
            return;
        }
        if (buffer.limit() == 0) {
            throw new RendererException("Attempting to upload empty buffer (limit = 0), that's an error");
        }
        if (buffer.remaining() == 0) {
            throw new RendererException("Attempting to upload empty buffer (remaining = 0), that's an error");
        }
    }

    public void glBufferData(int target, IntBuffer data, int usage) {
        LwjglGLExt.checkLimit(data);
        GL15.glBufferData((int)target, (IntBuffer)data, (int)usage);
    }

    public void glBufferSubData(int target, long offset, IntBuffer data) {
        LwjglGLExt.checkLimit(data);
        GL15.glBufferSubData((int)target, (long)offset, (IntBuffer)data);
    }

    public void glDrawArraysInstancedARB(int mode, int first, int count, int primcount) {
        ARBDrawInstanced.glDrawArraysInstancedARB((int)mode, (int)first, (int)count, (int)primcount);
    }

    public void glDrawBuffers(IntBuffer bufs) {
        LwjglGLExt.checkLimit(bufs);
        GL20.glDrawBuffers((IntBuffer)bufs);
    }

    public void glDrawElementsInstancedARB(int mode, int indices_count, int type, long indices_buffer_offset, int primcount) {
        ARBDrawInstanced.glDrawElementsInstancedARB((int)mode, (int)indices_count, (int)type, (long)indices_buffer_offset, (int)primcount);
    }

    public void glGetMultisample(int pname, int index, FloatBuffer val) {
        LwjglGLExt.checkLimit(val);
        ARBTextureMultisample.glGetMultisample((int)pname, (int)index, (FloatBuffer)val);
    }

    public void glTexImage2DMultisample(int target, int samples, int internalformat, int width, int height, boolean fixedsamplelocations) {
        ARBTextureMultisample.glTexImage2DMultisample((int)target, (int)samples, (int)internalformat, (int)width, (int)height, (boolean)fixedsamplelocations);
    }

    public void glVertexAttribDivisorARB(int index, int divisor) {
        ARBInstancedArrays.glVertexAttribDivisorARB((int)index, (int)divisor);
    }

    public Object glFenceSync(int condition, int flags) {
        return ARBSync.glFenceSync((int)condition, (int)flags);
    }

    public int glClientWaitSync(Object sync, int flags, long timeout) {
        return ARBSync.glClientWaitSync((GLSync)((GLSync)sync), (int)flags, (long)timeout);
    }

    public void glDeleteSync(Object sync) {
        ARBSync.glDeleteSync((GLSync)((GLSync)sync));
    }
}

