/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.base;

import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityChange;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.EntitySet;
import com.simsilica.es.base.DefaultEntity;
import com.simsilica.es.base.DefaultEntityData;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEntitySet
extends AbstractSet<Entity>
implements EntitySet {
    static Logger log = LoggerFactory.getLogger(DefaultEntitySet.class);
    private static RemovedComponent REMOVED_COMPONENT = new RemovedComponent();
    private Map<EntityId, Entity> entities = new HashMap<EntityId, Entity>();
    private ConcurrentLinkedQueue<EntityChange> changes = new ConcurrentLinkedQueue();
    private EntityData ed;
    private ComponentFilter mainFilter;
    private ComponentFilter[] filters;
    private Class[] types;
    private boolean filtersChanged = false;
    protected Transaction transaction = new Transaction();
    private Set<Entity> addedEntities = new HashSet<Entity>();
    private Set<Entity> changedEntities = new HashSet<Entity>();
    private Set<Entity> removedEntities = new HashSet<Entity>();
    private boolean released = false;

    public DefaultEntitySet(EntityData ed, ComponentFilter filter, Class[] types) {
        this.ed = ed;
        this.types = types;
        this.setMainFilter(filter);
    }

    protected Class[] getTypes() {
        return this.types;
    }

    public String debugId() {
        return "EntitySet@" + System.identityHashCode(this);
    }

    protected void setMainFilter(ComponentFilter filter) {
        this.mainFilter = filter;
        if (filter != null) {
            this.filters = new ComponentFilter[this.types.length];
            for (int i = 0; i < this.types.length; ++i) {
                if (filter.getComponentType() != this.types[i]) continue;
                this.filters[i] = filter;
            }
        } else {
            this.filters = null;
        }
    }

    protected ComponentFilter getMainFilter() {
        return this.mainFilter;
    }

    protected void loadEntities(boolean reload) {
        Set<EntityId> idSet = this.ed.findEntities(this.mainFilter, this.types);
        if (idSet.isEmpty()) {
            return;
        }
        EntityComponent[] buffer = new EntityComponent[this.types.length];
        for (EntityId id : idSet) {
            if (reload && this.containsId(id)) continue;
            for (int i = 0; i < buffer.length; ++i) {
                buffer[i] = this.ed.getComponent(id, this.types[i]);
            }
            DefaultEntity e = new DefaultEntity(this.ed, id, (EntityComponent[])buffer.clone(), this.types);
            if (!this.add(e) || !reload) continue;
            this.addedEntities.add(e);
        }
    }

    protected void purgeEntities() {
        Iterator<Entity> it = this.iterator();
        while (it.hasNext()) {
            Entity e = it.next();
            if (this.entityMatches(e)) continue;
            it.remove();
            this.removedEntities.add(e);
        }
    }

    @Override
    public void resetFilter(ComponentFilter filter) {
        this.setMainFilter(filter);
        this.filtersChanged = true;
    }

    @Override
    public boolean containsId(EntityId id) {
        return this.entities.containsKey(id);
    }

    @Override
    public Entity getEntity(EntityId id) {
        return this.entities.get(id);
    }

    @Override
    public boolean equals(Object o) {
        return o == this;
    }

    @Override
    public int size() {
        return this.entities.size();
    }

    @Override
    public Iterator<Entity> iterator() {
        return new EntityIterator();
    }

    @Override
    public void clear() {
        this.entities.clear();
    }

    @Override
    public boolean add(Entity e) {
        return this.entities.put(e.getId(), e) == null;
    }

    protected Entity remove(EntityId id) {
        return this.entities.remove(id);
    }

    @Override
    public boolean remove(Object e) {
        if (!(e instanceof Entity)) {
            return false;
        }
        return this.entities.remove(((Entity)e).getId()) != null;
    }

    @Override
    public boolean contains(Object e) {
        if (!(e instanceof Entity)) {
            return false;
        }
        return this.entities.containsKey(((Entity)e).getId());
    }

    @Override
    public Set<Entity> getAddedEntities() {
        return this.addedEntities;
    }

    @Override
    public Set<Entity> getChangedEntities() {
        return this.changedEntities;
    }

    @Override
    public Set<Entity> getRemovedEntities() {
        return this.removedEntities;
    }

    @Override
    public void clearChangeSets() {
        this.addedEntities.clear();
        this.changedEntities.clear();
        this.removedEntities.clear();
    }

    @Override
    public boolean hasChanges() {
        return !this.addedEntities.isEmpty() || !this.changedEntities.isEmpty() || !this.removedEntities.isEmpty();
    }

    @Override
    public boolean applyChanges() {
        return this.applyChanges(null);
    }

    @Override
    public boolean applyChanges(Set<EntityChange> updates) {
        return this.applyChanges(updates, true);
    }

    protected boolean buildTransactionChanges(Set<EntityChange> updates) {
        EntityChange change;
        if (this.changes.isEmpty()) {
            return false;
        }
        while ((change = this.changes.poll()) != null) {
            this.transaction.addChange(change, updates);
        }
        return true;
    }

    public boolean hasFilterChanged() {
        return this.filtersChanged;
    }

    protected boolean applyChanges(Set<EntityChange> updates, boolean clearChangeSets) {
        if (clearChangeSets) {
            this.clearChangeSets();
        }
        if (this.released) {
            this.changes.clear();
            this.removedEntities.addAll(this);
            this.clear();
            return this.hasChanges();
        }
        if (this.buildTransactionChanges(updates)) {
            this.transaction.resolveChanges();
        }
        if (this.filtersChanged) {
            this.filtersChanged = false;
            this.purgeEntities();
            this.loadEntities(true);
        }
        return !this.addedEntities.isEmpty() || !this.changedEntities.isEmpty() || !this.removedEntities.isEmpty();
    }

    @Override
    public void release() {
        if (this.ed instanceof DefaultEntityData) {
            ((DefaultEntityData)this.ed).releaseEntitySet(this);
        }
        this.released = true;
    }

    protected boolean isReleased() {
        return this.released;
    }

    protected boolean entityMatches(Entity e) {
        EntityComponent[] array = e.getComponents();
        for (int i = 0; i < this.types.length; ++i) {
            if (array[i] == null) {
                return false;
            }
            if (array[i] == REMOVED_COMPONENT) {
                array[i] = null;
                return false;
            }
            if (this.filters == null || this.filters[i] == null || this.filters[i].evaluate(array[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean isMatchingComponent(EntityComponent c) {
        for (int i = 0; i < this.types.length; ++i) {
            if (c.getClass() != this.types[i]) continue;
            if (this.filters != null && this.filters[i] != null) {
                return this.filters[i].evaluate(c);
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean hasType(Class type) {
        for (Class c : this.types) {
            if (c != type) continue;
            return true;
        }
        return false;
    }

    private int typeIndex(Class type) {
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] != type) continue;
            return i;
        }
        return -1;
    }

    protected boolean isRelevantChange(EntityChange change) {
        if (!this.hasType(change.getComponentType())) {
            if (log.isTraceEnabled()) {
                log.trace("   not our type.");
            }
            return false;
        }
        return true;
    }

    protected void entityChange(EntityChange change) {
        if (log.isTraceEnabled()) {
            log.trace("entityChange(" + change + ")");
        }
        if (!this.isRelevantChange(change)) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Adding change:" + change);
        }
        this.changes.add(change);
    }

    protected ConcurrentLinkedQueue<EntityChange> getChangeQueue() {
        return this.changes;
    }

    protected class Transaction {
        Map<EntityId, DefaultEntity> adds = new HashMap<EntityId, DefaultEntity>();
        Set<EntityId> mods = new HashSet<EntityId>();

        protected Transaction() {
        }

        public void directAdd(DefaultEntity e) {
            this.adds.put(e.getId(), e);
        }

        public void addChange(EntityChange change, Set<EntityChange> updates) {
            EntityId id = change.getEntityId();
            EntityComponent comp = change.getComponent();
            DefaultEntity e = (DefaultEntity)DefaultEntitySet.this.entities.get(id);
            if (e == null) {
                e = this.adds.get(id);
                if (e == null) {
                    if (comp == null) {
                        return;
                    }
                    if (!DefaultEntitySet.this.isMatchingComponent(comp)) {
                        return;
                    }
                    e = new DefaultEntity(DefaultEntitySet.this.ed, id, new EntityComponent[DefaultEntitySet.this.types.length], DefaultEntitySet.this.types);
                    this.adds.put(id, e);
                }
            } else {
                this.mods.add(id);
            }
            int index = comp == null ? DefaultEntitySet.this.typeIndex(change.getComponentType()) : DefaultEntitySet.this.typeIndex(comp.getClass());
            if (updates != null && (comp == null || DefaultEntitySet.this.filters == null || DefaultEntitySet.this.filters[index] == null || DefaultEntitySet.this.filters[index].evaluate(comp))) {
                updates.add(change);
            }
            e.getComponents()[index] = comp != null ? comp : REMOVED_COMPONENT;
        }

        protected boolean completeEntity(DefaultEntity e) {
            EntityComponent[] array = e.getComponents();
            for (int i = 0; i < DefaultEntitySet.this.types.length; ++i) {
                boolean rechecking = false;
                if (array[i] == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Pulling component type:" + DefaultEntitySet.this.types[i] + " for id:" + e.getId());
                    }
                    array[i] = DefaultEntitySet.this.ed.getComponent(e.getId(), DefaultEntitySet.this.types[i]);
                    if (array[i] == null) {
                        return false;
                    }
                } else {
                    if (array[i] == REMOVED_COMPONENT) {
                        array[i] = null;
                        return false;
                    }
                    rechecking = true;
                }
                if (DefaultEntitySet.this.filters == null || DefaultEntitySet.this.filters[i] == null || DefaultEntitySet.this.filters[i].evaluate(array[i])) continue;
                return false;
            }
            e.validate();
            return true;
        }

        public void resolveChanges() {
            for (DefaultEntity e : this.adds.values()) {
                if (!this.completeEntity(e) || !DefaultEntitySet.this.add(e)) continue;
                DefaultEntitySet.this.addedEntities.add(e);
            }
            for (EntityId id : this.mods) {
                Entity e = (Entity)DefaultEntitySet.this.entities.get(id);
                if (DefaultEntitySet.this.entityMatches(e)) {
                    DefaultEntitySet.this.changedEntities.add(e);
                    continue;
                }
                if (!DefaultEntitySet.this.remove(e)) continue;
                DefaultEntitySet.this.removedEntities.add(e);
            }
            this.adds.clear();
            this.mods.clear();
        }
    }

    private static class RemovedComponent
    implements EntityComponent {
        private RemovedComponent() {
        }
    }

    private class EntityIterator
    implements Iterator<Entity> {
        private Iterator<Map.Entry<EntityId, Entity>> delegate;

        public EntityIterator() {
            this.delegate = DefaultEntitySet.this.entities.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Entity next() {
            return this.delegate.next().getValue();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }
}

