/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.sql;

import com.google.common.base.Joiner;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityId;
import com.simsilica.es.filter.AndFilter;
import com.simsilica.es.filter.FieldFilter;
import com.simsilica.es.filter.OrFilter;
import com.simsilica.es.sql.FieldType;
import com.simsilica.es.sql.FieldTypes;
import com.simsilica.es.sql.SqlSession;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentTable<T> {
    static Logger log = LoggerFactory.getLogger(ComponentTable.class);
    private boolean cached = true;
    private Class<T> type;
    private FieldType[] fields;
    private String tableName;
    private String[] dbFieldNames;
    private String insertSql;
    private String updateSql;

    protected ComponentTable(Class<T> type, FieldType[] fields) {
        this.type = type;
        this.fields = fields;
        this.tableName = type.getSimpleName().toUpperCase();
        ArrayList<String> names = new ArrayList<String>();
        for (FieldType t : fields) {
            t.addFields("", names);
        }
        this.dbFieldNames = new String[names.size()];
        this.dbFieldNames = names.toArray(this.dbFieldNames);
        this.insertSql = this.createInsertSql();
        this.updateSql = this.createUpdateSql();
    }

    public static <T extends EntityComponent> ComponentTable<T> create(SqlSession session, Class<T> type) throws SQLException {
        List<FieldType> types = FieldTypes.getFieldTypes(type);
        FieldType[] array = new FieldType[types.size()];
        array = types.toArray(array);
        ComponentTable<T> result = new ComponentTable<T>(type, array);
        result.initialize(session);
        return result;
    }

    protected String createUpdateSql() {
        StringBuilder sql = new StringBuilder("UPDATE " + this.tableName);
        sql.append(" SET (");
        Joiner.on(", ").appendTo(sql, (Object[])this.dbFieldNames);
        sql.append(")");
        sql.append(" = ");
        sql.append("(");
        for (int i = 0; i < this.dbFieldNames.length; ++i) {
            sql.append((i > 0 ? ", " : "") + "?");
        }
        sql.append(")");
        sql.append(" WHERE entityId = ?");
        return sql.toString();
    }

    protected String createInsertSql() {
        StringBuilder sql = new StringBuilder("INSERT INTO " + this.tableName);
        sql.append(" (");
        Joiner.on(", ").appendTo(sql, (Object[])this.dbFieldNames);
        sql.append(", entityId");
        sql.append(")");
        sql.append(" VALUES ");
        sql.append("(");
        for (int i = 0; i < this.dbFieldNames.length; ++i) {
            sql.append((i > 0 ? ", " : "") + "?");
        }
        sql.append(", ?");
        sql.append(")");
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(SqlSession session) throws SQLException {
        DatabaseMetaData md = session.getConnection().getMetaData();
        log.info("Checking for table:" + this.tableName);
        ResultSet rs = md.getColumns(null, "PUBLIC", this.tableName, null);
        HashMap<String, Integer> dbFields = new HashMap<String, Integer>();
        try {
            while (rs.next()) {
                if (log.isTraceEnabled()) {
                    log.trace(rs.getString("TABLE_NAME") + " :" + rs.getString("COLUMN_NAME"));
                }
                dbFields.put(rs.getString("COLUMN_NAME"), rs.getInt("DATA_TYPE"));
            }
            dbFields.remove("ENTITYID");
        }
        finally {
            rs.close();
        }
        LinkedHashMap<String, FieldType> defs = new LinkedHashMap<String, FieldType>();
        for (FieldType t : this.fields) {
            t.addFieldDefinitions("", defs);
        }
        if (!dbFields.isEmpty()) {
            this.checkStructure(defs, dbFields);
            return;
        }
        StringBuilder sb = new StringBuilder("CREATE");
        if (this.cached) {
            sb.append(" CACHED");
        }
        sb.append(" TABLE");
        sb.append(" " + this.tableName + "\n");
        sb.append("(\n");
        sb.append("  entityId BIGINT PRIMARY KEY");
        for (Map.Entry e : defs.entrySet()) {
            sb.append(",\n  " + (String)e.getKey() + " " + ((FieldType)e.getValue()).getDbType());
        }
        sb.append("\n)");
        log.info("Create statement:\n" + sb);
        Statement st = session.getConnection().createStatement();
        int i = st.executeUpdate(sb.toString());
        st.close();
        log.info("Result:" + i);
    }

    protected void checkStructure(Map<String, FieldType> defs, Map<String, Integer> dbFields) throws SQLException {
        log.info("Table fields:" + dbFields);
        log.info("Object fields:" + defs);
        HashSet<String> newFields = new HashSet<String>();
        HashSet<String> removedFields = new HashSet<String>();
        for (String string : dbFields.keySet()) {
            if (defs.containsKey(string)) continue;
            removedFields.add(string);
        }
        for (String string : defs.keySet()) {
            if (dbFields.containsKey(string)) continue;
            newFields.add(string);
        }
        for (Map.Entry entry : dbFields.entrySet()) {
            FieldType ft = defs.get(entry.getKey());
            if (ft != null) continue;
        }
        log.info("New fields:" + newFields);
        log.info("Removed fields:" + removedFields);
        if (newFields.isEmpty() && removedFields.isEmpty()) {
            return;
        }
        if (!newFields.isEmpty() || !removedFields.isEmpty()) {
            throw new RuntimeException("Schema mismatch, table fields:" + dbFields + " object fields:" + defs.keySet());
        }
    }

    protected FieldType getFieldType(String field) {
        for (FieldType t : this.fields) {
            if (!t.getFieldName().equals(field)) continue;
            return t;
        }
        return null;
    }

    public void setComponent(SqlSession session, EntityId entityId, T component) throws SQLException {
        PreparedStatement st = session.prepareStatement(this.updateSql);
        int index = 1;
        for (FieldType t : this.fields) {
            index = t.store(component, st, index);
        }
        st.setObject(index++, entityId.getId());
        int result = st.executeUpdate();
        if (result > 0) {
            return;
        }
        st = session.prepareStatement(this.insertSql);
        index = 1;
        for (FieldType t : this.fields) {
            index = t.store(component, st, index);
        }
        st.setObject(index++, entityId.getId());
        result = st.executeUpdate();
    }

    public boolean removeComponent(SqlSession session, EntityId entityId) throws SQLException {
        String sql = "DELETE FROM " + this.tableName + " WHERE entityId=" + entityId.getId();
        PreparedStatement st = session.prepareStatement(sql.toString());
        int result = st.executeUpdate();
        return result > 0;
    }

    public T getComponent(SqlSession session, EntityId entityId) throws SQLException {
        StringBuilder sql = new StringBuilder("SELECT ");
        Joiner.on(", ").appendTo(sql, (Object[])this.dbFieldNames);
        sql.append(" FROM " + this.tableName);
        sql.append(" WHERE entityId=?");
        PreparedStatement st = session.prepareStatement(sql.toString());
        st.setObject(1, entityId.getId());
        ResultSet rs = st.executeQuery();
        try {
            if (rs.next()) {
                int index = 1;
                T target = this.type.newInstance();
                for (FieldType t : this.fields) {
                    index = t.load(target, rs, index);
                }
                T t = target;
                return t;
            }
            T index = null;
            return index;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error in table mapping", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error in table mapping", e);
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<EntityId> getEntityIds(SqlSession session) throws SQLException {
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append(" entityId");
        sql.append(" FROM " + this.tableName);
        HashSet<EntityId> results = new HashSet<EntityId>();
        PreparedStatement st = session.prepareStatement(sql.toString());
        ResultSet rs = st.executeQuery();
        try {
            while (rs.next()) {
                Long entityId = rs.getLong(1);
                results.add(new EntityId(entityId));
            }
        }
        finally {
            rs.close();
        }
        return results;
    }

    protected int appendFilter(FieldFilter f, StringBuilder where, List<Object> parms) {
        Object dbValue;
        FieldType ft = this.getFieldType(f.getFieldName());
        if (where.length() > 0) {
            where.append(" AND ");
        }
        if ((dbValue = ft.toDbValue(f.getValue())) == null) {
            where.append(f.getFieldName() + " IS NULL");
        } else {
            where.append(f.getFieldName() + " = ?");
            parms.add(dbValue);
        }
        return 1;
    }

    protected int appendFilter(OrFilter f, StringBuilder where, List<Object> parms) {
        if (where.length() > 0) {
            where.append(" AND ");
        }
        int count = 0;
        StringBuilder sub = new StringBuilder();
        for (ComponentFilter op : f.getOperands()) {
            int nested;
            if (count > 0) {
                where.append(" OR ");
            }
            if ((nested = this.appendFilter(op, sub, parms)) > 1) {
                where.append("(" + sub + ")");
            } else {
                where.append((CharSequence)sub);
            }
            sub.setLength(0);
            count += nested;
        }
        return count;
    }

    protected int appendFilter(AndFilter f, StringBuilder where, List<Object> parms) {
        if (where.length() > 0) {
            where.append(" AND ");
        }
        int count = 0;
        StringBuilder sub = new StringBuilder();
        for (ComponentFilter op : f.getOperands()) {
            int nested;
            if (count > 0) {
                where.append(" AND ");
            }
            if ((nested = this.appendFilter(op, sub, parms)) > 1) {
                where.append("(" + sub + ")");
            } else {
                where.append((CharSequence)sub);
            }
            sub.setLength(0);
            count += nested;
        }
        return count;
    }

    protected int appendFilter(ComponentFilter f, StringBuilder where, List<Object> parms) {
        if (f instanceof FieldFilter) {
            return this.appendFilter((FieldFilter)f, where, parms);
        }
        if (f instanceof OrFilter) {
            return this.appendFilter((OrFilter)f, where, parms);
        }
        if (f instanceof AndFilter) {
            return this.appendFilter((AndFilter)f, where, parms);
        }
        throw new IllegalArgumentException("Cannot handle filter:" + f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<EntityId> getEntityIds(SqlSession session, ComponentFilter filter) throws SQLException {
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append(" entityId");
        sql.append(" FROM " + this.tableName);
        ArrayList<Object> parms = new ArrayList<Object>();
        StringBuilder where = new StringBuilder();
        this.appendFilter(filter, where, parms);
        if (where.length() > 0) {
            sql.append(" WHERE " + where);
        }
        try {
            PreparedStatement st = session.prepareStatement(sql.toString());
            int index = 1;
            for (Object e : parms) {
                st.setObject(index++, e);
            }
            HashSet<EntityId> results = new HashSet<EntityId>();
            ResultSet resultSet = st.executeQuery();
            try {
                while (resultSet.next()) {
                    Long entityId = resultSet.getLong(1);
                    results.add(new EntityId(entityId));
                }
            }
            finally {
                resultSet.close();
            }
            return results;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error executing sql:" + sql, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityId getEntityId(SqlSession session, ComponentFilter filter) throws SQLException {
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append(" entityId");
        sql.append(" FROM " + this.tableName);
        ArrayList<Object> parms = new ArrayList<Object>();
        StringBuilder where = new StringBuilder();
        this.appendFilter(filter, where, parms);
        if (where.length() > 0) {
            sql.append(" WHERE " + where);
        }
        PreparedStatement st = session.prepareStatement(sql.toString());
        int index = 1;
        for (Object e : parms) {
            st.setObject(index++, e);
        }
        ResultSet rs = st.executeQuery();
        try {
            if (rs.next()) {
                Long l = rs.getLong(1);
                EntityId entityId = new EntityId(l);
                return entityId;
            }
        }
        finally {
            rs.close();
        }
        return null;
    }

    public Iterator<Map.Entry<EntityId, T>> components(SqlSession session) throws SQLException {
        ArrayList<ComponentReference<T>> results = new ArrayList<ComponentReference<T>>();
        StringBuilder sql = new StringBuilder("SELECT ");
        Joiner.on(", ").appendTo(sql, (Object[])this.dbFieldNames);
        sql.append(", entityId");
        sql.append(" FROM " + this.tableName);
        PreparedStatement st = session.prepareStatement(sql.toString());
        ResultSet rs = st.executeQuery();
        try {
            while (rs.next()) {
                int index = 1;
                T target = this.type.newInstance();
                for (FieldType t : this.fields) {
                    index = t.load(target, rs, index);
                }
                Long entityId = rs.getLong(index);
                results.add(new ComponentReference<T>(new EntityId(entityId), target));
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error in table mapping", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error in table mapping", e);
        }
        finally {
            rs.close();
        }
        return results.iterator();
    }

    private class ComponentReference<T>
    implements Map.Entry<EntityId, T> {
        private EntityId entityId;
        private T component;

        public ComponentReference(EntityId entityId, T component) {
            this.entityId = entityId;
            this.component = component;
        }

        @Override
        public EntityId getKey() {
            return this.entityId;
        }

        @Override
        public T getValue() {
            return this.component;
        }

        @Override
        public T setValue(T value) {
            throw new UnsupportedOperationException("Cannot set the component on a reference.");
        }
    }
}

