
import com.google.common.base.Function;
import com.google.common.base.Predicate;

import com.simsilica.mattacks.achievement.*;


class FactoryDecorator implements Function<AchievementContext, Achievement> {
    
    private Function<AchievementContext, Achievement> delegate;
    private Closure config;
    
    public FactoryDecorator( Function<AchievementContext, Achievement> delegate, Closure config ) {
        this.delegate = delegate;
        this.config = config;
    }
    
    public Achievement apply( AchievementContext context ) {
        Achievement result = delegate.apply(context);
        result.with(config);
        return result;
    } 
}

AchievementRule.metaClass {    
    
    rule = { Closure predicate ->
        delegate.rule = predicate as Predicate
    }
    
    achievement = { Closure config ->
        delegate.factory = new FactoryDecorator(delegate.factory, config);
    }
}

Collection.metaClass {
    best = {
        AchievementUtils.best(delegate)
    }
}

levelAchievement = { String name, Closure config ->

    def rule = new AchievementRule(AchievementType.Level, name)
    rule.with(config)
    achievementsContext.getRules().add(rule);   
}

categoryAchievement = { String name, Closure config ->

    def rule = new AchievementRule(AchievementType.Category, name)
    rule.with(config)
    achievementsContext.getRules().add(rule);   
}

dailyAchievement = { String name, Closure config ->

    def rule = new AchievementRule(AchievementType.Daily, name)
    rule.with(config)
    achievementsContext.getRules().add(rule);   
}

weeklyAchievement = { String name, Closure config ->

    def rule = new AchievementRule(AchievementType.Weekly, name)
    rule.with(config)
    achievementsContext.getRules().add(rule);   
} 
