

levelAchievement("Attempted") {
    description = "Try the level."
    score = 1
    rule {
        currentScore.total >= 0
    }
}


levelAchievement("Passed") {
    description = "Pass the level."
    score = 2
    rule {
        currentScore.percent >= 0.7
    }
}

levelAchievement("Bronze") {
    description = "80% correct."
    score = 3
    rule {
        currentScore.percent >= 0.8
    }
}

levelAchievement("Silver") {
    description = "90% correct."
    score = 4
    rule {
        currentScore.percent >= 0.9
    }
}

levelAchievement("Gold") {
    description = "Perfect score."
    score = 5
    rule {
        currentScore.percent >= 1.0
    }
}

categoryAchievement("Attempted") {
    description = "Try one level."
    score = 1
    rule {
        it.categoryAchievements.count { it.level != null && it.name=="Attempted" } >= 1         
    }    
}

categoryAchievement("Practiced") {
    description = "Pass at least one level, try another."
    score = 2
    rule {
        def ours = it.categoryAchievements.findAll { it.level != null }   
        def result = ours.count { it.name=="Attempted" } >= 2         
        result && ours.count { it.name=="Passed" } >= 1
    }
}

categoryAchievement("Bronze") {
    description = "Scaled score >= 8"
    score = 3
    rule {
        //println "What is it?:" + it
        //println "Test best:" +
        def best = it.categoryAchievements.findAll { it.level != null }.best() 
        println "Test the best:" + best 
        def totalScore = best.sum { it.totalScore }
        println "Test score:" + totalScore
        return totalScore >= 8; 
    }
}

categoryAchievement("Silver") {
    description = "Scaled score >= 12"
    score = 4
    rule {
        def best = it.categoryAchievements.findAll { it.level != null }.best() 
        def totalScore = best.sum { it.totalScore }
        return totalScore >= 12; 
    }
}

categoryAchievement("Gold") {
    description = "Scaled score >= 15"
    score = 5
    rule {
        def best = it.categoryAchievements.findAll { it.level != null }.best() 
        def totalScore = best.sum { it.totalScore }
        return totalScore >= 15; 
    }
}

dailyAchievement("Practice") {
    description = "Practice at least three categories."
    score = 1
    rule {
        def day = it.dayAchievements.findAll { it.level == null && it.category != null } 
        day.count { it.score == 1 } >= 3
    }
}

dailyAchievement("Passed") {
    description = "Pass at least three categories."
    score = 2
    rule {
        def day = it.dayAchievements.findAll { it.level == null && it.category != null }
println "Passed check day:" + day         
        day.count { it.score == 2 } >= 3
    }
}

dailyAchievement("Bronze") {
    description = "Bronze one category and pass at least three categories."
    score = 3
    rule {
        def day = it.dayAchievements.findAll { it.level == null && it.category != null }
        def passed = day.count { it.score == 2 }
        def bronzed = day.count { it.score == 3 }    
        println "Day:" + day
        println "Passed:" + passed
        println "Bronzed:" + bronzed
        passed >= 3 && bronzed >= 1
    }
}

dailyAchievement("Silver") {
    description = "Silver one category and pass at least three categories."
    score = 4
    rule {
        def day = it.dayAchievements.findAll { it.level == null && it.category != null }
        def passed = day.count { it.score == 2 }
        def silver = day.count { it.score == 4 }    
        println "Day:" + day
        println "Passed:" + passed
        println "Silver:" + silver
        passed >= 3 && silver >= 1
    }
}

dailyAchievement("Gold") {
    description = "Gold one category and pass at least three categories."
    score = 5
    rule {
        def day = it.dayAchievements.findAll { it.level == null && it.category != null }
        def passed = day.count { it.score == 2 }
        def gold = day.count { it.score == 5 }    
        println "Day:" + day
        println "Passed:" + passed
        println "Gold:" + gold
        passed >= 3 && gold >= 1
    }
}

weeklyAchievement("Ice Cream") {
    description = "2 Gold OR 3 Bronze OR 5 Passed OR 6 Practiced days."
    score = 1
    rule {
        def week = it.weekAchievements.findAll { it.level == null && it.category == null }
        def gold = week.count { it.score == 5 }
        def bronze = week.count { it.score == 3 }
        def passed = week.count { it.score == 2 }
        def practiced = week.count { it.score == 1 }
        
        println "Week:" + week
        println "Gold:" + gold
        println "Bronze:" + bronze
        println "Passed:" + passed
        println "Practiced:" + practiced
        
        return gold >= 2 || bronze >= 3 || passed >= 5 || practiced >= 6
    }
}


/*
Weekly roll-up:
-6 days (1)
-5 days (2)
-3 days (3)
-2 days gold  
*/
